/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "daemon/INotification.h"

namespace NS_DM_Client
{
	enum EnumFirmwareOperation
	{
		e_FWOError = 0,
		e_FWODownload,
		e_FWOUpdate,
		e_FWODownloadAndUpdate
	};

	extern const char* S_notificationStatusDescription[];

	class INotificationUpdater: public INotification
	{
	public:
		INotificationUpdater(void* context = 0): m_context(context) {} ;
		virtual ~INotificationUpdater() {};

		virtual void StartDMSessionStatus(bool isStarted) {};
		virtual void CheckFirmwareUpdateStatus(bool isNewFirmware) {};
		virtual void ProvisioningUpdate(const StringArray& URIs, CommandType command, EventType eventType, StatusCode resultCode) {};

		// status on notification's subscription
		virtual void NotifyDMSessionStatus(EventType eventType, Initiator initiator, NotificationStatus statusCode) {};

		virtual void FirmwareInfo(const String &localpath, const String &filename, const int size) {};
		virtual void FirmwareUpdateStart(FirmwareUpdate::EnumFirmwareOperation fwo) {};
		virtual void FirmwareUpdateFinished(FirmwareUpdate::EnumFirmwareOperation fwo) {};
		virtual void StartDRMDCollecting(int duration) {};

		virtual void FirmwareUpdateNotif(EnumFirmwareOperation fwo, NotificationStatus status) {};

	private:
		void* m_context;
	};
}
