/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include <vector>
#include "commontypes.h"
#include "Errors.h"

namespace NS_DM_Client
{

enum UIOptionalParameter
{
    e_MINDT = 0,
    e_MAXDT,
    e_DR,
    e_MAXLEN,
    e_IT,
    e_ET
};

struct UIOptionalParameterData
{
    UIOptionalParameterData() {}
    UIOptionalParameterData(UIOptionalParameter parameter, const String& data)
        : m_parameter(parameter), m_data(data)
    {
    }

    UIOptionalParameter m_parameter;
    String m_data;
};

typedef std::vector<UIOptionalParameterData> UIOptionalParameters;

////typedef std::vector<String> UserAvialableChoiseSet;
typedef std::vector<String> UserAvailableChoiseSet;
typedef std::vector<int> UserChoiseSet;

}
