/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "platform.h"

#if defined(PLATFORM_ANDROID)
    #include "stddef.h" // <cstddef> is empty in Android environment !!!
#else
    #include <cstddef>
#endif

namespace NS_DM_Client
{

    namespace NS_NotificationListener
    {
        class IDataSink
        {
        public:
            virtual ~IDataSink(void) {}

            virtual void    Write(const void* buf, size_t size) = 0;

        protected:
            IDataSink(){}

        private:
            IDataSink(IDataSink&);
            IDataSink& operator = (IDataSink&);

        };

    }
}

