/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

extern "C"
{
typedef     void*(*CREATE_FUNC)(long);
}

#include "commontypes.h"

namespace NS_DM_Client
{
    class DynamicLoader
    {
    public:

        typedef     void*   LIBHANDLE;

        DynamicLoader();
        ~DynamicLoader();

        void*   Load(const char* lib, const char* method, long param);
        const char* GetLoadErrorDescription() const;
        void    Unload();

    private:
        DynamicLoader(const DynamicLoader&);
        DynamicLoader& operator = (const DynamicLoader&);

    private:
        LIBHANDLE   m_handle;
        String	m_error;
    };
}
