/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <vector>
#include <list>
#include <map>
#include <string>
#include <base/util/StringMap.h>
#include <syncml/core/DevInf.h>

//#include "common/FString.h"
typedef std::string String;

#include "Logger/Logger.h"

#if defined(PLATFORM_ANDROID)
#include <sys/types.h>
//// 2013.04.24
////#include "badalloc.h"
#endif

#include <boost/shared_ptr.hpp>


namespace NS_DM_Client
{
    typedef unsigned char   byte_t;
	typedef unsigned int    uint;

	typedef Funambol::StringBuffer FStringBuffer;

	typedef boost::shared_ptr<Funambol::DevInf> DevInfPtr;

//	typedef std::string String;
//	typedef Funambol::StringBuffer String;
	
	typedef String URI;

    typedef std::vector<char>	buffer_t;
	typedef std::vector<String> StringArray;
	typedef std::list<String>   StringList;
    typedef std::map<String, String> StrMap;
	typedef Funambol::StringMap StringMap;
	typedef const char *        cstr;
		
	#define SAFE_DELETE(ptr)	\
		do {					\
			if (ptr) {			\
				LOG_DEBUG_(NS_Logging::GetLogger("SAFE_DELETE"),"delete %p", ptr);	\
				delete ptr;		\
				ptr = NULL;		\
			}					\
		}while(0)

	#define SAFE_DELETE_ARR(ptr)\
		do {					\
			if (ptr) {			\
				LOG_DEBUG_(NS_Logging::GetLogger("SAFE_DELETE"),"delete [] %p", ptr);	\
				delete [] ptr;	\
				ptr = NULL;		\
			}					\
		}while(0)
}

