/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "platform.h"
#include "commontypes.h" 

#ifdef PLATFORM_LINUX
#define DM_ENGINE_API
#elif defined(PLATFORM_WINDOWS)
#ifdef DM_ENGINE_EXPORTS
#define DM_ENGINE_API __declspec(dllexport)
#else
#define DM_ENGINE_API __declspec(dllimport)
#endif // DM_ENGINE_EXPORTS
#else
#define DM_ENGINE_API 
#endif

namespace NS_DM_Client
{
	class IExecutionQueue;
	class IServerExchangeManager;
	class IMOTreeManager;
	class INotificationListener;
    class INotificationCenter;

	class IDeviceAdapter;
	class DynamicLoader;
	class IDaemonEngineRequest;

	namespace NS_Daemon
	{
		class Profile;
	}

    namespace NS_DataStorage
    {
        class IDataStorage;
    }
    typedef NS_DataStorage::IDataStorage    IDataStorage;

	class DM_ENGINE_API ProfileComponentsHolder
	{
	public:
		ProfileComponentsHolder(const NS_Daemon::Profile& profile);
		~ProfileComponentsHolder(void);

//         const char*             GetProfileName() const;
//         void                    SetProfileName(const char*);

        //      to support profile separated logging
        //         Logger&                 GetLogger();
        //         void                    SetLogger(Logger&);

		IExecutionQueue*		GetExecutionQueue();
		IServerExchangeManager*	GetServerExchangeManager();
		IMOTreeManager*			GetMOTreeManager();
		INotificationListener*	GetNotificationListener();
		IDataStorage*			GetDataStorage();
		IDeviceAdapter*			GetDeviceAdapter();
		INotificationCenter*	GetNotificationCenter();
		IDaemonEngineRequest*	GetDaemonEngineRequest();

		void					SetExecutionQueue(IExecutionQueue*);
		void					SetServerExchangeManager(IServerExchangeManager*);
		void					SetMOTreeManager(IMOTreeManager*);
		void					SetNotificationListener(INotificationListener*);
		void					SetDataStorage(IDataStorage*);
		void					SetDeviceAdapter(IDeviceAdapter*, DynamicLoader* = 0);
		void					SetNotificationCenter(INotificationCenter*);
		void					SetDaemonEngineRequest(IDaemonEngineRequest*);
		
		const String&					GetProfileType() const;

	private:
		ProfileComponentsHolder(const ProfileComponentsHolder&);
		ProfileComponentsHolder& operator=(const ProfileComponentsHolder&);

    private:
		IExecutionQueue*		m_ExecQueue;
		IServerExchangeManager*	m_ServExchange;
		IMOTreeManager*			m_MOTree;
		INotificationListener*	m_NotificationListener;
		IDataStorage*			m_DataStorage;
		IDeviceAdapter*			m_DeviceAdapter;
		DynamicLoader* 			m_DeviceAdapterDynamicLoader;
		INotificationCenter*	m_NotificationCenter;
		IDaemonEngineRequest*	m_daemonEngineRequest;

		String					m_ProfileType;
	};

	
	class PCHAware
	{
	public:
		PCHAware(ProfileComponentsHolder &pch) : m_pch(pch) {};
		
	protected:
		ProfileComponentsHolder &m_pch;
	};
}
