#pragma once

#include "http/CurlTransportAgent.h"

namespace Funambol
{

class CurlTransportAgentEx : public CurlTransportAgent
{
public:
    CurlTransportAgentEx (URL& url, Proxy& proxy, unsigned int timeout)
    : Funambol::CurlTransportAgent(url, proxy, timeout)
    {}

    char* query(ArrayList& httpHeaders, long* protocolResponseCode);

};

char* Funambol::CurlTransportAgentEx::query(ArrayList& httpHeaders, long* protocolResponseCode)
{
    if (!easyhandle) {
        setError(ERR_NETWORK_INIT, "libcurl error init error");
        return NULL;
    }

    curl_slist *slist=NULL;
    char *response = NULL;
    CURLcode code;

    if (!httpHeaders.isEmpty())
    {
    	StringBuffer* el = (StringBuffer*)httpHeaders.front();
		while (el)
		{
			slist = curl_slist_append(slist, el->c_str());
			el = (StringBuffer*)httpHeaders.next();
		}
    }
    responsebuffersize = 64 * 1024;
    responsebuffer = new char[responsebuffersize];
    received = 0;
    responsebuffer[0] = 0;
    // todo? url.resource
    const char *certificates = getSSLServerCertificates();
    if ((code = curl_easy_setopt(easyhandle, CURLOPT_HTTPGET, true)) ||
        (code = curl_easy_setopt(easyhandle, CURLOPT_URL, url.fullURL)) ||
        (code = curl_easy_setopt(easyhandle, CURLOPT_HTTPHEADER, slist)) ||
        /*
         * slightly cheating here: when CURLOPT_CAINFO was set before, we don't unset it because
         * we don't know what the default is
         */
        (certificates[0] && (code = curl_easy_setopt(easyhandle, CURLOPT_CAINFO, certificates))) ||
        (code = curl_easy_setopt(easyhandle, CURLOPT_SSL_VERIFYPEER, (long)SSLVerifyServer)) ||
        (code = curl_easy_setopt(easyhandle, CURLOPT_SSL_VERIFYHOST, (long)(SSLVerifyHost ? 2 : 0))) ||
        (code = curl_easy_perform(easyhandle))) {
        delete [] responsebuffer;
        setErrorF(ERR_HTTP, "libcurl error %d, %.250s", code, curlerrortxt);
    } else {
        response = responsebuffer;

    }
    responseSize = received;

    long res_code = 0;
    if (protocolResponseCode)
    {
        *protocolResponseCode = (curl_easy_getinfo(easyhandle, CURLINFO_RESPONSE_CODE, &res_code) == CURLE_OK)
			? res_code : 0;
    }

    responsebuffer = NULL;
    responsebuffersize = 0;

    if (slist) {
        curl_slist_free_all(slist);
    }

    return response;
}

}


