/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <syncml/core/Status.h>
#include "serverexchange/wrappers/SResponseCommand.h"


namespace NS_DM_Client
{
	namespace NS_SyncMLCommand
	{
		typedef boost::shared_ptr<class SStatusCommand> SStatusCommandPtr;

		class SStatusCommand : public NS_SyncMLCommand::SResponseCommand
		{
		public:
			SStatusCommand();
			SStatusCommand(int data);
			SStatusCommand(int data, AbstractCommandPtr origcmd);
			virtual ~SStatusCommand();

			Funambol::Status * GetStatus();
			int  GetData();
			void SetData(int data);

			void SetCmd(const char *cmdName);
			const char * GetCmd() { return m_cmdName; };

			void SetTargetRef(const char *target);
			void SetSourceRef(const char *source);

			virtual Funambol::StringBuffer * ToString();

			StatusPtr Internal() {
				return boost::static_pointer_cast<Funambol::Status>(m_ptrItemizedCommand); }

		protected:
			virtual void createItemizedCommand();

		private:
			int m_data;

			char *m_cmdName;
			char *m_targetref;
			char *m_sourceref;

			inline Funambol::Status *this_status()
			{
				return static_cast<Funambol::Status*>(m_ptrItemizedCommand.get());
			}
		};
	}
}
