/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "executionqueue/ICommand.h"
#include "treemanager/ActionCommand.h"

namespace NS_DM_Client
{
	class ProfileComponentsHolder;
	
	namespace NS_SyncMLCommand
	{
		/// Command that is able to
		class AlertCommand : public ActionCommand
		{
		public:
			AlertCommand(ProfileComponentsHolder * pHolder,
						 AlertPtr& cmd,
						 const String& msgID,
						 const char* serverId = 0);
			virtual ~AlertCommand() {};
			virtual bool Execute();

		protected:
			AlertPtr m_AlertCommand;
			
			virtual MOTreeResponseCommand * CreateResponse();

		private:
			std::vector<String> m_results;
			AlertCommand(const AlertCommand&);
			AlertCommand& operator =(const AlertCommand&);

			StatusCode handleAlert(int alertcode);
			StatusCode performOperation();
		};
	}
}
