
LOCAL_PATH := $(call my-dir)

##### libClientAdapter ########################################################

include $(CLEAR_VARS)

LOCAL_SRC_FILES :=									\
	clientadapterproxy/ClientAdapter.cpp			\
	clientadapterproxy/ClientAdapterProxy.cpp		\
	clientadapterproxy/ThreadHelper.cpp			\
	common/MessageDeserializer.cpp					\
	common/MessageSerializer.cpp					\
	common/Message.cpp								\
	common/CommonUtils.cpp							\
	common/ProvisionInfo.cpp
LOCAL_LDLIBS  := 								\
	-Lout/apps/oma_dm_client/armeabi		\
	-Lout/apps/FunambolSDK/armeabi			\
	-lfunambol

LOCAL_C_INCLUDES += $(ALL_CINCLUDES) $(LOCAL_PATH)/../../include/DaemonDM/ $(LOCAL_PATH)/common/
LOCAL_CFLAGS += $(ALL_CFLAGS)

LOCAL_STATIC_LIBRARIES := FifoWrapper Common Diagnostics \
	ManagementObjects TNDSMgmtTree ServerExchangeManager
LOCAL_SHARED_LIBRARIES := Logger

LOCAL_MODULE := ClientAdapter

include $(BUILD_STATIC_LIBRARY)

##### libClientAdapterStub ####################################################

include $(CLEAR_VARS)

LOCAL_SRC_FILES :=									\
	clientadapterstub/ClientAdapterStub.cpp			\
	clientadapterstub/RequestReceiverThread.cpp		\
	clientadapterstub/RequestHandlingThread.cpp		\
	clientadapterstub/IMOTreeCommand.cpp			\
	clientadapterstub/GetCommand.cpp				\
	clientadapterstub/SetCommand.cpp				\
	clientadapterstub/SetMgmtTreeCommand.cpp		\
	clientadapterstub/GetMgmtTreeCommand.cpp		\
	clientadapterstub/NotificationStub.cpp			\
	clientadapterstub/ProvisionHolder.cpp			\
	clientadapterstub/UIRequestHandler.cpp			\
	clientadapterstub/RequestMessageHandler.cpp		\
	clientadapterstub/ProfileActivationStatusCommand.cpp		\
	clientadapterstub/ProfileActivationStatusByServerIDCommand.cpp	\
	common/MessageDeserializer.cpp					\
	common/MessageSerializer.cpp					\
	common/Message.cpp								\
	common/CommonUtils.cpp							\
	common/ProvisionInfo.cpp
	
LOCAL_C_INCLUDES += $(ALL_CINCLUDES) $(LOCAL_PATH)/../../include/DaemonDM/ $(LOCAL_PATH)/common/
LOCAL_CFLAGS += $(ALL_CFLAGS)

LOCAL_MODULE := ClientAdapterStub
include $(BUILD_STATIC_LIBRARY)

##### libTestClientAdapter ########################################################

include $(CLEAR_VARS)

LOCAL_SRC_FILES :=									\
	TestClientAdapterDll/TestClientAdapter.cpp		\
	TestClientAdapterDll/Utils.cpp						\
	TestClientAdapterDll/ConfirmationImpl.cpp

LOCAL_C_INCLUDES += $(ALL_CINCLUDES)
LOCAL_CFLAGS += $(ALL_CFLAGS)

LOCAL_LDLIBS  := 								\
	-L$(OUT_FUNAMBOL)			\
	-lfunambol -llog

LOCAL_STATIC_LIBRARIES := ClientAdapter FifoWrapper Common Diagnostics \
	ManagementObjects TNDSMgmtTree ServerExchangeManager
LOCAL_SHARED_LIBRARIES := Logger 

LOCAL_MODULE := TestClientAdapter

include $(BUILD_SHARED_LIBRARY)

##### libJNIAdapterTestClientAdapter ####################################################

include $(CLEAR_VARS)
LOCAL_MODULE:= JNIAdapterTestClientAdapter
LOCAL_SRC_FILES := android/jni/com_funambol_omadmclient_android_testclientadapter_TestClientAdapter.cpp

LOCAL_C_INCLUDES += $(ALL_CINCLUDES)
LOCAL_CFLAGS += $(ALL_CFLAGS)

LOCAL_SHARED_LIBRARIES := TestClientAdapter

include $(BUILD_SHARED_LIBRARY)

##### libJNITestRemoteClientAdapter ####################################################

include $(CLEAR_VARS)
LOCAL_MODULE:= JNITestRemoteClientAdapter
LOCAL_SRC_FILES := TestRemoteClientAdapter/jni/com_funambol_omadmclient_android_testremoteclientadapter_TestRemoteClientAdapter.cpp

LOCAL_C_INCLUDES += $(ALL_CINCLUDES)
LOCAL_C_INCLUDES += $(LOCAL_PATH)/common
LOCAL_CFLAGS += $(ALL_CFLAGS)

LOCAL_SHARED_LIBRARIES := ClientAdapter

include $(BUILD_SHARED_LIBRARY)


