#pragma once

#include "treemanager/IMOTreeManager.h"

namespace NS_DM_Client
{

	class MockMOTreeManager: public IMOTreeManager
	{
	public:
		// from IComponent
		virtual bool Init(const StringMap& settings, const String& loggerInstance, ProfileComponentsHolder& pch);
		virtual bool Start();
		virtual bool Stop();
		virtual void Release();

		// from IMOTreeManager
		virtual bool Exist(const URI& uri, const char* serverId = 0) { return false; };

		virtual StatusCode Get(const URI& uri, Funambol::Item& item, const char* serverId = 0);
		virtual StatusCode GetValue(const URI& uri, String& value, const char* serverId = 0);

		virtual StatusCode GetPropertyValue(const URI& uri, const String& property_name, String& value, const char* serverId = 0);

		virtual StatusCode GetChildren(const URI& uri, ChildrenPaths& children, const char* serverId = 0);

		virtual StatusCode GetAttributeStructData(const URI& uri, Funambol::ArrayList& items, const char* serverId = 0);
		virtual StatusCode GetAttributeTNDS(const URI& uri, const RequiredProperties& requiredProp, Funambol::StringBuffer*& xml, const char* serverId = 0) { return e_Ok; };

		virtual StatusCode SetPropertyValue(const URI& uri, const String& property_name, const String& value);
		virtual StatusCode Add(const URI& uri, const Funambol::Item& item, const char* serverId = 0, bool isUpdateRequired = true);
		virtual StatusCode Delete(const URI& uri, const char* serverId = 0);
		virtual StatusCode Replace(const URI& uri, const Funambol::Item& item, const char* serverId = 0, bool isUpdateRequired = true);

		virtual StatusCode ReplacePropertyValue(const URI& uri, const String& property_name, const String& new_value, const char* serverId = 0);

		virtual StatusCode Copy(const URI& source, const URI& dest, const char* serverId = 0);

		virtual StatusCode ExecPermitted(const URI& path, const char* serverId = 0);

		virtual StatusCode StartTransaction();
		virtual StatusCode Rollback();
		virtual StatusCode Commit();
	};
}
