#include "SynchRunThread.h"
#include "Message.h"
#include "../clientadapterproxy/ClientAdapterProxy.h"
#include "ClientAdapter/INotificationUpdater.h"
#include "ManagementObjects/DevInfo.h"
#include <iostream>
#include "ClientAdapter/ProvisionInfo.h"

SynchRunThread::SynchRunThread(NS_DM_Client::ClientAdapterProxy& proxy, size_t requestType, size_t requestSubType, 
							   void* mgmtObject): 	m_proxy(proxy), m_requestType(requestType), 
							   m_requestSubType(requestSubType), m_mgmtObject(mgmtObject), m_provisionInfo(0)
{
}
//-------------------------------------------------------------------------------------------

SynchRunThread::SynchRunThread(NS_DM_Client::ClientAdapterProxy& proxy, size_t requestType, size_t requestSubType, 
							   const std::string& tndsMgmtObject): 	m_proxy(proxy), m_requestType(requestType), 
							   m_requestSubType(requestSubType), m_mgmtObject(0), m_tndsMgmtObject(tndsMgmtObject), 
							   m_provisionInfo(0)
{
}
//-------------------------------------------------------------------------------------------

SynchRunThread::~SynchRunThread()
{
	delete m_provisionInfo;
}
//-------------------------------------------------------------------------------------------

void SynchRunThread::run()
{
	bool res = false;
	switch (m_requestType)
	{
	case NS_DM_Client::e_open:
		res = m_proxy.Open();
		break;
	case NS_DM_Client::e_close:
		res = m_proxy.Close();
		break;
	case NS_DM_Client::e_set:
		{
			switch (m_requestSubType)
			{
			case NS_DM_Client::e_devInfo:
				if (m_mgmtObject)
				{
					res = m_proxy.SetDeviceInfo(*(reinterpret_cast<NS_DM_Client::DevInfo*>(m_mgmtObject)));
				}
				else
				{
					res = m_proxy.SetMgmtTree(m_tndsMgmtObject);
				}
				break;
			case NS_DM_Client::e_clientProfileName:
				res = m_proxy.SwitchClientProfile("ProfileName");
				break;
			}
			break;
		}
	case NS_DM_Client::e_get:
		{
			switch (m_requestSubType)
			{
			case NS_DM_Client::e_devInfo:
				{
					if (m_mgmtObject)
					{
						NS_DM_Client::DevInfo* devInfo = reinterpret_cast<NS_DM_Client::DevInfo*>(m_mgmtObject);
						res = m_proxy.GetDeviceInfo(*devInfo);
					}
					else
					{
						//res = m_proxy.GetMgmtTree(NS_DM_Client::e_MODevInfo, m_tndsMgmtObject);
					}
					break;
				}
			}
			break;
		}
	case NS_DM_Client::e_clientProfiles:
		{
			std::vector<NS_DM_Client::ClientProfileInfo>* profiles = 
				reinterpret_cast<std::vector<NS_DM_Client::ClientProfileInfo>*>(m_mgmtObject);
			res = m_proxy.GetClientProfiles(*profiles);
			break;
		}
	case NS_DM_Client::e_startDMSession:
		{
			NS_DM_Client::IStatusCallback* callback = 
				reinterpret_cast<NS_DM_Client::IStatusCallback*>(m_mgmtObject);
			res = m_proxy.StartDMSession("AlertMessage", callback);
			break;
		}
	case NS_DM_Client::e_notifyProvisioningUpdate:
		{
 			NS_DM_Client::INotificationUpdater* updater = 
 				reinterpret_cast<NS_DM_Client::INotificationUpdater*>(m_mgmtObject);

			if (m_provisionInfo)
				res = m_proxy.SubscribeToNotification(*m_provisionInfo, updater);
// 			res = m_proxy.NotifyProvisionUpdate(updater);
			break;
		}
	default:
		break;
	}
 	if (res)
 		std::cout << "	Success" << std::endl;
 	else
 		std::cout << "	ERROR!!!" << std::endl;
}
//-------------------------------------------------------------------------------------------

void SynchRunThread::SetProvisionInfo(const NS_DM_Client::ProvisionInfoRequest& provisionInfo)
{
	m_provisionInfo = new NS_DM_Client::ProvisionInfoRequest(provisionInfo);
}
//-------------------------------------------------------------------------------------------


