#pragma once

#include "PortableThread.h"
#include <string>

namespace NS_DM_Client
{
	class ClientAdapterProxy;
	class IMgmtObject;
	struct ProvisionInfoRequest;
}

class SynchRunThread: public Funambol::FThread
{
public:
	SynchRunThread(NS_DM_Client::ClientAdapterProxy& proxy, size_t requestType, 
		size_t requestSubType = 0, void* mgmtObject = 0);
	SynchRunThread(NS_DM_Client::ClientAdapterProxy& proxy, size_t requestType, size_t requestSubType, 
		const std::string& tndsMgmtObject);
	~SynchRunThread();
	void run();
	
	void SetProvisionInfo(const NS_DM_Client::ProvisionInfoRequest& provisionInfo);

private:
	NS_DM_Client::ClientAdapterProxy& m_proxy;
	size_t m_requestType;
	size_t m_requestSubType;
//	NS_DM_Client::IMgmtObject& m_mgmtObject;
	void* m_mgmtObject;
	std::string m_tndsMgmtObject;
	NS_DM_Client::ProvisionInfoRequest* m_provisionInfo;
};