/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "IMOTreeCommand.h"
#include "common/commontypes.h"

namespace NS_DM_Client
{
	class ProfileComponentsHolder;
	class IMgmtObject;

	namespace NS_Common
	{
		class EventEx;
	}

    class GetMgmtTreeCommand: public IMOTreeCommand
    {
	public:
		GetMgmtTreeCommand(ProfileComponentsHolder* holder, const String& uri, String& mgmtTree, 
			NS_Common::EventEx* executionCompleted, bool& executionResult);
		virtual ~GetMgmtTreeCommand() {};

	protected:
		virtual bool run(IMOTreeManager& treeManager);

	private:
		String m_uri;
		String& m_mgmtTree;
    };
}

