/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "executionqueue/ICommand.h"
#include "treemanager/MOTreeCommand.h"

namespace NS_Logging
{
	class Logger;
}

namespace NS_DM_Client
{
	class ProfileComponentsHolder;
	class ICommandDispatcher;
	class IMgmtObject;
	class IMOTreeManager;

	namespace NS_Common
	{
		class EventEx;
	}

    class IMOTreeCommand: public MOTreeCommand
    {
    public:
        IMOTreeCommand(ProfileComponentsHolder* holder, IMgmtObject* mgmtObject, 
			NS_Common::EventEx* executionCompleted, bool& executionResult);
        virtual ~IMOTreeCommand();

//		virtual bool Visit(ICommandDispatcher& cmdDispatcher);
		virtual bool Execute();

    protected:
        virtual bool invokeResult();
		virtual bool run(IMOTreeManager& treeManager) = 0;

	protected:
		ProfileComponentsHolder* m_componentHolder;
		IMgmtObject* m_mgmtObject;
		NS_Common::EventEx* m_executionCompleted;
		bool& m_executionResult;
		NS_Logging::Logger& m_logger;

		bool	m_started;
    };
}

