/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "IPCDaemonEngineActionThread.h"
#include "DaemonDM/IPCDaemonEngine.h"
#include "daemon/IDaemonEngine.h"
#include "common/Buffer.h"
#include "MessengerDefs.h"
#include "Logger/Logger.h"

namespace NS_DM_Client
{

//------------------------------------------------------------------------------------------------------
IPCDaemonEngineActionThread::IPCDaemonEngineActionThread()
{

}
//------------------------------------------------------------------------------------------------------
IPCDaemonEngineActionThread::~IPCDaemonEngineActionThread()
{

}
//------------------------------------------------------------------------------------------------------
IPCDaemonEngineActionThread& IPCDaemonEngineActionThread::operator=(IPCDaemonEngineActionThread&)
{
    #ifndef PLATFORM_ANDROID
        throw "error: trying to call operator= for IPCDaemonEngineActionThread";
    #else
        NULL;
    #endif

    return *this;
}
//------------------------------------------------------------------------------------------------------
IPCDaemonEngineActionThread::IPCDaemonEngineActionThread(IPCDaemonEngineActionThread&)
{
    #ifndef PLATFORM_ANDROID
        throw "error: trying to call copy constructor for IPCDaemonEngineActionThread";
    #else
        NULL;
    #endif
}
//------------------------------------------------------------------------------------------------------
bool IPCDaemonEngineActionThread::Init(IPCDaemonEngine* engine)
{
    m_engine = engine;
    return true;
}
//------------------------------------------------------------------------------------------------------
bool IPCDaemonCheckStopCondition(const Buffer& buffer)
{
    char stop_request[c_StopRequestSize + 1];/*c_StopRequestSize*/
    memset(stop_request, '\0', c_StopRequestSize + 1);
    memcpy(stop_request, buffer.GetPointer(), c_StopRequestSize);
    if (strcmp(stop_request, c_StopRequest) == 0)
    {
        return true;
    }
    return false;
}
//------------------------------------------------------------------------------------------------------
void IPCDaemonEngineActionThread::run()
{
    IFIFOWrapper* fifo_request, *fifo_response;
    while (true)
    {
        if (!initializeIPCFifos(fifo_request, fifo_response, false, true))
        {
            return;
        }
        while (true)
        {
            UIExchangeHead request_head;
            Buffer buffer(sizeof(UIExchangeHead), '\0');
            if (fifo_request->Read(buffer) == e_Ok)
            {
                if (IPCDaemonCheckStopCondition(buffer))
                {   // stop thread
                    releaseFifos(fifo_request, fifo_response);
                    return;
                }
                memset(&request_head, 0, sizeof(UIExchangeHead));
                memcpy(&request_head, buffer.GetPointer(), sizeof(UIExchangeHead));
                buffer.Allocate(request_head.m_payload_size, '\0');
                if (fifo_request->Read(buffer) == e_Ok)
                {
                    Buffer response_payload;
                    UIResponseExchangeHead response_head;
                    memset(&response_head, 0, sizeof(UIResponseExchangeHead));
                    StatusCode request_status =
                        m_engine->GetDaemonEngine()->HandleClientRequest(request_head.m_type, buffer, response_head.m_perform_code, response_payload);
                    if (request_status != e_Ok)
                    {
                        response_head.m_perform_code = e_Failed;
                        response_head.m_payload_size = 0;
                    }
                    else
                    {
                        response_head.m_payload_size = response_payload.Size();
                    }

                    buffer.Allocate(sizeof(response_head) + response_head.m_payload_size, '0');
                    memcpy(buffer.GetPointer(), &response_head, sizeof(response_head));
                    if (response_head.m_payload_size > 0)
                    {
                        memcpy(((char*)buffer.GetPointer()) + sizeof(response_head), response_payload.GetPointer(), response_payload.Size());
                    }
                    fifo_response->Write(buffer);
                }
            }
            else
            {
                releaseFifos(fifo_request, fifo_response);
                break;
            }
        }
    }
    return;
}

}
