#include "CUIMessageHandler.h"

#include "iostream"

using namespace std;

namespace NS_DM_Client
{

CUIMessageHandler::CUIMessageHandler(const char* default_user_input, const char* default_user_confirm, const char* default_user_choise, bool* downloadCancel)
{
    memset(m_defUserInput, '\0', cMaxDefSize);
    memset(m_defUserConfirm, '\0', 2);
    memset(m_defUserChoise, '\0', cMaxDefSize);

    if (default_user_input)
    {
        memcpy(m_defUserInput, default_user_input, strlen(default_user_input));
    }

    if (default_user_confirm)
    {
        memcpy(m_defUserConfirm, default_user_confirm, 1);
    }

    if (default_user_choise)
    {
        memcpy(m_defUserChoise, default_user_choise, strlen(default_user_choise));
    }

    m_downloadCancel = false;

    if (downloadCancel)
    {
        m_downloadCancel = *downloadCancel;
    }
}

bool CUIMessageHandler::Init()
{


    return true;
}

bool CUIMessageHandler::Release()
{

    return true;
}

StatusCode CUIMessageHandler::Display(const char* message, long min_time, long max_time)
{
    cout << "---- Display interaction ----" << endl;
    cout << "Message: " << message << endl;
    cout << "Min time: " << min_time << endl;
    cout << "Max time: " << max_time << endl;

    cout << "Display success" << endl;

    return e_Ok;
}

StatusCode CUIMessageHandler::Confirmation(const char* message, long min_time, long max_time)
{
    cout << "---- Confirmation interaction ----" << endl;
    cout << "Message: " << message << endl;
    cout << "Min time: " << min_time << endl;
    cout << "Max time: " << max_time << endl;

    if (strlen(m_defUserConfirm) > 0)
    {
        if ((m_defUserConfirm[0] == 'y') || (m_defUserConfirm[0] == 'Y'))
        {
            return e_Ok;
        }
        else
        {
            return e_NotModified;
        }
    }
    else
    {
        cout << "write \'Y\' or \'y\' if confirm. Write any else if not confirm" << endl;

        char input[256];
        for (size_t i = 0; i < 256; ++i)
        {
            input[i] = '\0';
        }

        char* ress = fgets(input, 255, stdin);
        if (ress && strlen(input) > 0)
        {
            if ((input[0] == 'y') || (input[0] == 'Y'))
            {
                return e_Ok;
            }
            else
            {
                return e_NotModified;
            }
        }
    }

    return e_OperationCancelled;
}

StatusCode CUIMessageHandler::UserInput(const char* message, long min_time, long max_time, char*& input,
        long* max_len, bool echo_password)
{
    cout << "---- UserInput interaction ----" << endl;
    cout << "Message: " << message << endl;
    cout << "Min time: " << min_time << endl;
    cout << "Max time: " << max_time << endl;

    size_t len;
    if (max_len)
    {
        cout << "max length is presented:" << *max_len << endl;
        len = size_t(*max_len);
    }
    else
    {
        cout << "max length not presented. Use default: 256" << endl;
        len = 256;
    }

    cout << "Echo type: ";
    if (echo_password)
    {
        cout << "hidden" << endl;
    }
    else
    {
        cout << "visible" << endl;
    }

    input = new char[len];
    for (size_t i = 0; i < len; ++i)
    {
        input[i] = '\0';
    }

    if (strlen(m_defUserInput) > 0)
    {
        memcpy(input, m_defUserInput, strlen(m_defUserInput));
    }
    else
    {
        char* ress = fgets(input, len - 1, stdin);
        if (!ress)
        {
            // some error
        }
        input[strlen(input)-1] = '\0';
    }

    cout << endl;
    return e_Ok;
}

StatusCode CUIMessageHandler::UserChoice(const char* message, long min_time, long max_time,
        const char* avialable_choise_set, char*& choise_set, bool allowMultipleChoises)
{

    cout << "---- UserChoice interaction ----" << endl;
    cout << "Message: " << message << endl;
    cout << "Min time: " << min_time << endl;
    cout << "Max time: " << max_time << endl;

    char c_manyChoises[4];
    if (allowMultipleChoises)
    {
        memcpy(c_manyChoises, "yes", 3);
        c_manyChoises[3] = '\0';
    }
    else
    {
        memcpy(c_manyChoises, "no", 2);
        c_manyChoises[2] = '\0';
    }

    cout << "Allow multiple choises: " << c_manyChoises << endl;
    cout << "Avialable choises set: " << avialable_choise_set << endl;

    size_t len = strlen(avialable_choise_set) + 1;
    choise_set = new char[len];
    for (size_t i = 0; i < len; ++i)
    {
        choise_set[i] = '\0';
    }

    if (strlen(m_defUserChoise) > 0)
    {
        memcpy(choise_set, m_defUserChoise, len - 1);

    }
    else
    {
        char* ress = fgets(choise_set, len - 1, stdin);
        if (!ress)
        {
            // some error
        }
        choise_set[strlen(choise_set)-1] = '\0';
    }


    cout << endl;

    return e_Ok;
}
StatusCode CUIMessageHandler::ProgressNotification(const char* message, long min_time, long max_time,
        long size_to_download)
{
    cout << "---- ProgressNotification interaction ----" << endl;
    cout << "Message: " << message << endl;
    cout << "Min time: " << min_time << endl;
    cout << "Max time: " << max_time << endl;

    cout << "size to download: " << size_to_download << endl;

    if (m_downloadCancel)
    {
        cout << "ProgressNotification cancelled by user" << endl;
        return e_OperationCancelled;
    }

    cout << "ProgressNotification success" << endl;
    return e_Ok;
}

void CUIMessageHandler::ReleaseString(char* str)
{
    delete[](str);
}

CUIMessageHandler::~CUIMessageHandler()
{


}


}
