/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#include "DaemonDM/Messenger.h"
#include "DaemonDM/MessageListener.h"
#include <Logger/LoggerMacroses.h>

const char* const c_LogName = "UserIntercation";

namespace NS_DM_Client
{

//------------------------------------------------------------------------------------------------------
Messenger* CreateMessenger()
{
    Messenger* res = new(std::nothrow) Messenger;
    if(res == (Messenger*)NULL)
    {
        GDLERROR("new Messenger");
        return (Messenger*)NULL;
    }
    if (res->Init() != e_Ok)
    {
        res->Release();
        res = (Messenger*)NULL;
    }

    return res;
}
//------------------------------------------------------------------------------------------------------
MessageListener* CreateMessageListener(IMessageHandler* message_handler)
{
    MessageListener* res = new(std::nothrow) MessageListener;
    if(res == (MessageListener*)NULL)
    {
        GDLERROR("new MessageListener");
        return (MessageListener*)NULL;
    }
    if (res->Init(message_handler) != e_Ok)
    {
        res->Release();
        res = (MessageListener*)NULL;
    }

    return res;
}
//------------------------------------------------------------------------------------------------------

}
