package com.funambol.omadmclient.android.service;

import android.content.Intent;
import android.app.Service;
import android.util.Log;

public class NotificationCallbackInterface 
{
    static private Service m_service = null;
    
    static public String m_message = null;
    static public boolean m_result = false; 
    static public NotificationCallbackInterface m_callBack = null;
    static public int m_status = Constants.e_CommandFailed;
    static public String m_input = "";
    static public long m_max_len = 0;
    static public String m_choice_set = "";
    
    static private final String LOGTAG = "NotificationCallbackInterface";
    static private final String CHOICE_SEPARATER ="-";
    
    public NotificationCallbackInterface() 
    {
    }

    public NotificationCallbackInterface(Service service) 
    {
        if (m_service == null)
        {
            m_service = service;
        }

        m_callBack = this;
    }

    public static int DisplayCallBack(String message) 
    {
        Log.i(LOGTAG, "enter >> DisplayCallBack");

        int res = Constants.e_CommandFailed;

        // show UIAlertWindow 
        if (m_service != null)
        {
            Log.i(LOGTAG, "before >> Intent alertIntent = new Intent()");
            Intent alertIntent = new Intent();
            Log.i(LOGTAG, "before >> alertIntent.setAction");
            alertIntent.setAction("com.oma_dm_client.service.uiAlertWindow");
            Log.i(LOGTAG, "before >> alertIntent.setFlags");
            alertIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            alertIntent.putExtra(Constants.UIALERTTYPE,Constants.UIALERT_TYPE_DISPLAY);
            if (message != null)
            {
                Log.i(LOGTAG, "before >> alertIntent.putExtra(AlertText, s)");
                m_message = message;
                alertIntent.putExtra(Constants.UIALERTTEXT,message);
            }
            else
            {
                Log.e(LOGTAG, "error: s == null");
            }
            m_service.startActivity(alertIntent);

            // to do: synchronize
            m_result = false;
            m_status = Constants.e_CommandFailed;
            boolean stillWaiting = true;
            while (stillWaiting)
            {
                try
                 {
                    synchronized(m_callBack) 
                    {
                        m_callBack.wait();
                    }
                if(m_result)
                {
                	res = m_status;
                }
                stillWaiting = false;
                }
                catch (InterruptedException e)
                {
                        String str = "Interrupt: %s" + e.getMessage();
                    Log.i(LOGTAG, str);
                }
            }
        }
        else
        {
            Log.e(LOGTAG, "error: m_service == null");
        }

        String str = "leave << DisplayCallBack: " + Integer.toString(res);
        Log.i(LOGTAG, str);
        return res;
    }
    
    public static int ConfirmationCallBack(String message) 
    {
        Log.i(LOGTAG, "enter >> ConfirmationCallBack");

        int res = Constants.e_CommandFailed;

        // show notifications screen 
        if (m_service != null)
        {
            Log.i(LOGTAG, "before >> Intent alertIntent = new Intent()");
            Intent alertIntent = new Intent();
            Log.i(LOGTAG, "before >> alerIntent.setAction");
            alertIntent.setAction("com.oma_dm_client.service.uiAlertWindow");
            Log.i(LOGTAG, "before >> alertIntent.setFlags");
            alertIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            alertIntent.putExtra(Constants.UIALERTTYPE,Constants.UIALERT_TYPE_CONFIRMATION);
            if (message != null)
            {
                Log.i(LOGTAG, "before >> alertIntent.putExtra(Notification, s)");
                m_message = message;
                alertIntent.putExtra(Constants.UIALERTTEXT,message);
            }
            else
            {
                Log.e(LOGTAG, "error: s == null");
            }
            m_service.startActivity(alertIntent);

            // to do: synchronize
            m_result = false;
            m_status = Constants.e_CommandFailed;
            boolean stillWaiting = true;
            while (stillWaiting)
            {
                try
                 {
                    synchronized(m_callBack) 
                    {
                        m_callBack.wait();
                    }
                    if(m_result)
                    {
                    	res = m_status;
                    }
                stillWaiting = false;
                }
                catch (InterruptedException e)
                {
                    String str = "Interrupt: %s" + e.getMessage();
                    Log.i(LOGTAG, str);
                }
            }
        }
        else
        {
            Log.e(LOGTAG, "error: m_service == null");
        }
        
        String str = "leave << ConfirmationCallBack: " + Integer.toString(res);
        Log.i(LOGTAG, str);
        return res;
    }
    
    public static int UserInputCallBack(String message, String[] input, long max_len, boolean echo_password) 
    {
        Log.i(LOGTAG, "enter >> UserInputCallBack");

       int res = Constants.e_CommandFailed;
       m_max_len = max_len;

        // show notifications screen 
        if (m_service != null)
        {
            Log.i(LOGTAG, "before >> Intent alertIntent = new Intent()");
            Intent alertIntent = new Intent();
            Log.i(LOGTAG, "before >> alerIntent.setAction");
            alertIntent.setAction("com.oma_dm_client.service.uiAlertWindow");
            Log.i(LOGTAG, "before >> alertIntent.setFlags");
            alertIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            alertIntent.putExtra(Constants.UIALERTTYPE,Constants.UIALERT_TYPE_INPUT);
            if (message != null)
            {
                Log.i(LOGTAG, "before >> alertIntent.putExtra(Notification, s)");
                m_message = message;
                alertIntent.putExtra(Constants.UIALERTTEXT,message);
            }
            else
            {
                Log.e(LOGTAG, "error: s == null");
            }
            m_service.startActivity(alertIntent);

            // to do: synchronize
            m_result = false;
            m_status = Constants.e_CommandFailed;
            boolean stillWaiting = true;
            while (stillWaiting)
            {
                try
                 {
                    synchronized(m_callBack) 
                    {
                        m_callBack.wait();
                    }
                    if(m_result)
                    {
                    	res = m_status;
                    	if(m_status == Constants.e_OK)
                    	{
                    		input[0] = m_input;
                    	}
                    }
                stillWaiting = false;
                }
                catch (InterruptedException e)
                {
                    String str = "Interrupt: %s" + e.getMessage();
                    Log.i(LOGTAG, str);
                }
            }
        }
        else
        {
            Log.e(LOGTAG, "error: m_service == null");
        }
        
        String str = "leave << UserInputCallBack: " + Integer.toString(res);
        Log.i(LOGTAG, str);
    	
    	return res;
    }
  
    public static int UserChoiceCallBack(String message, String avialable_choise_set, String[] choise_set, boolean allowMultipleChoises) 
    {
        Log.i(LOGTAG, "enter >> UserChoiceCallBack");

        int res = Constants.e_CommandFailed;

         // show notifications screen 
         if (m_service != null)
         {
             Log.i(LOGTAG, "before >> Intent alertIntent = new Intent()");
             Intent alertIntent = new Intent();
             Log.i(LOGTAG, "before >> alerIntent.setAction");
             alertIntent.setAction("com.oma_dm_client.service.uiAlertWindow");
             Log.i(LOGTAG, "before >> alertIntent.setFlags");
             alertIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
             if(allowMultipleChoises)
             {
            	 alertIntent.putExtra(Constants.UIALERTTYPE,Constants.UIALERT_TYPE_MULTIPLECHOISE);
             }
             else
             {
            	 alertIntent.putExtra(Constants.UIALERTTYPE,Constants.UIALERT_TYPE_CHOICE);
             }
             if (message != null)
             {
                 Log.i(LOGTAG, "before >> alertIntent.putExtra(Notification, s)");
                 m_message = message;
                 alertIntent.putExtra(Constants.UIALERTTEXT,message);
             }
             else
             {
                 Log.e(LOGTAG, "error: message == null");
             }
             if (avialable_choise_set != null)
             {
            	 String str = "avialable_choise_set: " + avialable_choise_set;
            	 Log.i(LOGTAG, str);
                 String[] strArray = avialable_choise_set.split(CHOICE_SEPARATER);
                 if(strArray.length == 0)
                 {
                	 Log.e(LOGTAG, "error: avialable_choise_set is invalid");
                	 alertIntent.putExtra(Constants.AVAILABLE_CHOICE_ITEMS,new String[]{""});
                 }
                 else
                 {
                	 alertIntent.putExtra(Constants.AVAILABLE_CHOICE_ITEMS,strArray);
                 }
             }
             else
             {
                 Log.e(LOGTAG, "error: avialable_choise_set == null");
             }
             
             m_service.startActivity(alertIntent);

             // to do: synchronize
             m_result = false;
             m_status = Constants.e_CommandFailed;
             boolean stillWaiting = true;
             while (stillWaiting)
             {
                 try
                  {
                     synchronized(m_callBack) 
                     {
                         m_callBack.wait();
                     }
                     if(m_result)
                     {
                     	res = m_status;
                     	if(m_status == Constants.e_OK)
                     	{
                     		choise_set[0] = m_choice_set;
                     	}
                     }
                 stillWaiting = false;
                 }
                 catch (InterruptedException e)
                 {
                     String str = "Interrupt: %s" + e.getMessage();
                     Log.i(LOGTAG, str);
                 }
             }
         }
         else
         {
             Log.e(LOGTAG, "error: m_service == null");
         }
         
         String str = "leave << UserChoiceCallBack: " + Integer.toString(res);
         Log.i(LOGTAG, str);
     	
     	return res;
    }
}
