/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */
#pragma once

////#ifndef CDATASTORAGE_H_INCLUDED
////#define CDATASTORAGE_H_INCLUDED

#include "DataStorage/IDataStorage.h"
#include "lock.h"

#include <stdio.h>

namespace NS_DM_Client
{

namespace NS_DataStorage
{

class Logger;

class CDataStorage;
class CStreamHandler : public IStreamHandler
{
    friend class CDataStorage;
public:
    virtual ~CStreamHandler();
protected:
    CStreamHandler(FILE* file, String file_name);
    virtual bool Write(const void* buffer, size_t size);
    virtual bool Write(const Buffer& buffer);
    virtual bool FinishWriting();
    virtual void Release();

private:
    FILE* m_file;
    String m_name;
    bool m_isFinishWriting;
    //CMutualSyncHandler m_sync;
    NS_Common::CritSection m_sync;
};


class CDataStorage : public IDataStorage
{
public:
    virtual ~CDataStorage() { }
    CDataStorage(const String& profile);
    virtual bool Init(const String& base_path = "");
    virtual void Release();

    virtual IStreamHandler* CreateStream();

    virtual bool SavePrivateData(const String& key, const void* buffer, size_t size, bool profileSpecific = true);
    virtual bool SavePrivateData(const String& key, const Buffer& buffer, bool profileSpecific = true);
    virtual bool LoadPrivateData(const String& key, Buffer& buffer, bool profileSpecific = true);

    virtual bool RemovePrivateData(const String& key);

    virtual bool GetChildList(const String& key, StringArray& list, bool profileSpecific = true);

    virtual bool Exist(const String& key, bool profileSpecific = true);
    virtual const char* GetBasePath();

    virtual bool GetPrivateDataSize(const String& key, size_t& size, bool profileSpecific = true);
private:
    bool encryptAndSave(FILE* fin, const char* key, const void* buffer, size_t size);
    bool savePrivateData(const char* key, const void* buffer, size_t size);
    bool loadPrivateData(const char* key, void*& buffer, size_t& size);
    bool readBufferSize(const char* key, size_t& size);
    bool isPrivateDataFileType(const char* path);

    bool createPrivateDataPath(const char* key, bool profileSpecific = true);
    void tryRemovePrivateDataPath(const char* key);

    bool isCorrectDataPath(const char* path, const char* node);

    const String m_profile;
    String m_base_path;

    NS_Common::CritSection m_sync;
};

class CConfigurationStorage : public IConfigurationStorage
{
public:
    ~CConfigurationStorage();
    CConfigurationStorage();

    virtual bool Init();
    virtual void Release();

    /// functions for daemon's configuration
    virtual bool SaveConfiguration(const void* buffer, size_t size);
    virtual bool SaveConfiguration(const Buffer& buffer);
    virtual bool LoadConfiguration(Buffer& buffer);
private:
    IDataStorage* m_DataStorage;
};


}


}
////#endif // CDATASTORAGE_H_INCLUDED
