/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "CDataStorage.h"
#include "DataStorageDefs.h"

#include <sys/stat.h>
#include <sys/types.h>

#include <string.h>

#include "Logger/Logger.h"

#include "common/Buffer.h"

namespace NS_DM_Client
{
namespace NS_DataStorage
{

//------------------------------------------------------------------------------------------------------
CStreamHandler::CStreamHandler(FILE* file, String name)
    : m_file(file), m_name(name), m_isFinishWriting(false)
{
}
//------------------------------------------------------------------------------------------------------
CStreamHandler::~CStreamHandler()
{
    if (m_file)
    {
        //SYNC_STREAM_HANDLER_LOCK

        fclose(m_file);

        //SYNC_UNLOCK

        // unlink(m_name.c_str());
    }
}
//------------------------------------------------------------------------------------------------------
bool CStreamHandler::Write(const void* buffer, size_t size)
{
    bool res = m_file && buffer && (size > 0) && (!m_isFinishWriting);
    if (res)
    {
        //SYNC_STREAM_HANDLER_LOCK

        res = (fwrite(buffer, 1, size, m_file) == size);

        //SYNC_UNLOCK
    }
    return res;
}
//------------------------------------------------------------------------------------------------------
bool CStreamHandler::Write(const Buffer& buffer)
{
    return Write(buffer.GetPointer(), buffer.Size());
}
//------------------------------------------------------------------------------------------------------
bool CStreamHandler::FinishWriting()
{
    bool res = m_file && (!m_isFinishWriting);
    if (res)
    {
        //SYNC_STREAM_HANDLER_LOCK

        if (fclose(m_file) == 0)
        {
            res = m_isFinishWriting = ((m_file = fopen(m_name.c_str(), "r")) != 0);
        }
        else
        {
            // error logging
        }

       // SYNC_UNLOCK
    }
    return res;
}
//------------------------------------------------------------------------------------------------------
void CStreamHandler::Release()
{
    delete this;
}

}

}
