/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "CDataStorage.h"
#include "DataStorageDefs.h"
#include "common/Buffer.h"

#include "Logger/Logger.h"

namespace NS_DM_Client
{
namespace NS_DataStorage
{

//------------------------------------------------------------------------------------------------------
CStreamHandler::CStreamHandler(FILE* file, String name)
    : m_file(file), m_name(name), m_isFinishWriting(false)
{
}
//------------------------------------------------------------------------------------------------------
CStreamHandler::~CStreamHandler()
{
    if (m_file)
    {
    }
}
//------------------------------------------------------------------------------------------------------
bool CStreamHandler::Write(const void* buffer, size_t size)
{
    bool res = m_file && buffer && (size > 0) && (!m_isFinishWriting);
    if (res)
    {
		// under construction
		res = true;
	}
    return res;
}
//------------------------------------------------------------------------------------------------------
bool CStreamHandler::Write(const Buffer& buffer)
{
    return Write(buffer.GetPointer(), buffer.Size());
}
//------------------------------------------------------------------------------------------------------
bool CStreamHandler::FinishWriting()
{
    bool res = m_file && (!m_isFinishWriting);
    if (res)
    {
		// under construction
		res = true;
	}
    return res;
}
//------------------------------------------------------------------------------------------------------
void CStreamHandler::Release()
{
    delete this;
}

}

}
