/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "NotificationListener/ListenerThread.h"
#include "NotificationListener/UDPListener.h"

using namespace NS_DM_Client::NS_NotificationListener;

ListenerThread::ListenerThread(UDPListener& listener, IDataSink* dataSink)
:m_listener(listener),
m_stopped(true),
m_dataSink(dataSink)
{
}


ListenerThread::~ListenerThread(void)
{
}


void ListenerThread::run()
{
    m_stopped = false;
    m_listener.Listen(m_dataSink);
    m_stopped = true;
}


void ListenerThread::softTerminate()
{
    if (!m_stopped)
    {
        m_listener.Stop();
        wait(500);  // TODO use sychronization object (maybe in UDPListener::Stop)
    }
}

