/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include <base/util/utils.h>
#include "downloader.h"
#include "platform.h"

//#include "common/CurlDownloader.h"
#include "CurlDownloader.h"
/*#if defined(PLATFORM_LINUX)
    #include "posix/CurlDownloader.h"
#elif defined(PLATFORM_MAC)
    #include "posix/CurlDownloader.h"
#elif defined(PLATFORM_ANDROID)
    #include "posix/CurlDownloader.h"
#elif defined(PLATFORM_WINDOWS)
    #include "windows/WinDownloader.h"
#else
    # error No Downloader class defined for your platform
#endif

    */
#include <Logger/LoggerMacroses.h>

using namespace NS_DM_Client::NS_Common;


Downloader::Downloader() : m_error(DS_NOT_INITIALIZED), m_url(NULL), m_pDownloader(NULL)
{
    m_url = Funambol::stringdup("");
}

Downloader::Downloader(const char *URL) : m_error(0), m_url(NULL), m_pDownloader(NULL)
{
    m_url = Funambol::stringdup(URL);
}

Downloader::~Downloader()
{
    SAFE_DELETE_ARR(m_url);
    m_pDownloader = NULL;
}

void Downloader::setProperty(const char *pname, const char *pvalue)
{
    if (m_pDownloader)
        m_pDownloader->setProperty(pname, pvalue);
    else
        m_properties[pname] = pvalue;
}

int Downloader::storeBuffer(void *buffer, unsigned int size)
{
    if (m_pDownloader)
    {
        return m_pDownloader->storeBuffer(buffer, size);
    }
    return 0;
}

Downloader * DownloaderFactory::CreateDownloader(const char *URL)
{
    Downloader *d = NULL;
    d = new(std::nothrow) CurlDownloader(URL);
    /*
#if defined(PLATFORM_LINUX)
    d = new CurlDownloader(URL);
#elif defined(PLATFORM_MAC)
    d = new CurlDownloader(URL);
#elif defined(PLATFORM_ANDROID)
    d = new CurlDownloader(URL);
#elif defined(PLATFORM_WINDOWS)
    d = new WinDownloader(URL);
#else
    # error No Downloader class defined for your platform
#endif
    */
    return d;
}

