/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "PropertiesReader.h"
#include "Utils.h"

using namespace NS_Common;

PropertiesReader::PropertiesReader(const char *filepath) : m_filepath(filepath)
{
    read();
}

PropertiesReader::PropertiesReader(String &filepath) : m_filepath(filepath)
{
    read();
}

const PropertiesReader::Properties::iterator PropertiesReader::begin()
{
    return m_properties.begin();
}

const PropertiesReader::Properties::iterator PropertiesReader::end()
    
	return m_properties.end();
}

size_t PropertiesReader::size() const
{
    return m_properties.size();
}

void PropertiesReader::read()
{
    char strName[256];
    char strValue[256];
    FILE *fp = NULL;

    if (NS_DM_Client::__fopen(m_filepath.c_str(), "r", fp) && fp)
    {
        while(!feof(fp))
        {
            memset(strName, '\0', 256);
            memset(strValue, '\0', 256);
            if (2 == fscanf(fp, "%s =%s", &strName[0], &strValue[0]))
            {
                m_properties.push_back(Property(&strName[0], &strValue[0]));
            }
        }
        fclose(fp);
    }
}
