/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "common/IConfigurationParser.h"

namespace NS_DM_Client
{

class XMLConfigurationParser : public IConfigurationParser
{
public:
    XMLConfigurationParser();
    virtual ~XMLConfigurationParser();

    virtual void Release();

    virtual bool Init(const char* configuration, const char* group = 0);
    virtual bool GetProperty(const String& name, String& value);

private:
    bool checkGroupExist();
    bool getProperty(const String& name, String& value);

    XMLConfigurationParser(const XMLConfigurationParser&);
    XMLConfigurationParser& operator =(const XMLConfigurationParser&);

    bool m_isGroup;
    String m_xml;
    String m_group;
};

}
