/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "Event.h"

using namespace NS_DM_Client::NS_Common;

Event::Event(bool autoReset) : m_signaled(false), m_autoReset(autoReset)
{
    pthread_cond_init(&m_condition, NULL);
    pthread_mutex_init(&m_mutex, NULL);
}

Event::~Event()
{
    pthread_cond_destroy(&m_condition);
    pthread_mutex_destroy(&m_mutex);
}

void Event::wait()
{
    pthread_mutex_lock(&m_mutex);

    while (!m_signaled)
        pthread_cond_wait(&m_condition, &m_mutex);

    if (m_autoReset)
        m_signaled = false;

    pthread_mutex_unlock(&m_mutex);
}

void Event::reset()
{
    pthread_mutex_lock(&m_mutex);
    m_signaled = false;
    pthread_mutex_unlock(&m_mutex);
}

void Event::signal()
{
    pthread_mutex_lock(&m_mutex);

    if (!m_signaled)
    {
        m_signaled = true;
        pthread_cond_signal(&m_condition);
    }

    pthread_mutex_unlock(&m_mutex);
}

EventEM::EventEM(pthread_mutex_t &m) : m_mutex(m)
{
    pthread_cond_init(&m_condition, NULL);
}

EventEM::~EventEM()
{
    pthread_cond_destroy(&m_condition);
}

void EventEM::wait()
{
    pthread_mutex_lock(&m_mutex);
    pthread_cond_wait(&m_condition, &m_mutex);
    pthread_mutex_unlock(&m_mutex);
}

void EventEM::signal()
{
    pthread_mutex_lock(&m_mutex);
    pthread_cond_signal(&m_condition);
    pthread_mutex_unlock(&m_mutex);
}

EventEx::EventEx()
: m_param (e_NotDefined), m_signaled(false)
{
}

EventEx::~EventEx()
{
    m_param = e_NotDefined;
    m_signaled = false;
}

long EventEx::wait()
{
    pthread_mutex_lock(&m_mutex);
    if (!m_signaled)
    {
        pthread_cond_wait(&m_condition, &m_mutex);
    }
    long param = m_param;
    m_signaled = false;
    pthread_mutex_unlock(&m_mutex);

    return param;
}

void EventEx::signal(long param)
{
    pthread_mutex_lock(&m_mutex);
    m_signaled = true;
    m_param = param;
    pthread_cond_signal(&m_condition);
    pthread_mutex_unlock(&m_mutex);
}

void EventEx::signal()
{
    signal(e_NotDefined);
}
