#include "CritSection.h"

namespace NS_DM_Client
{
	namespace NS_Common
	{
		CritSection::CritSection()
		{
			m_mutex = CreateMutex(NULL, FALSE, NULL);
		}

		CritSection::~CritSection()
		{
			CloseHandle(m_mutex);
		}


		void CritSection::Lock()
		{
			WaitForSingleObject(m_mutex, INFINITE);
		}


		int CritSection::TryLock()
		{
			return (WAIT_OBJECT_0 == WaitForSingleObject(m_mutex, 0) ? 0 : 1); // return 0 on success
			//return ::TryEnterCriticalSection(&m_critsection) ? 0 : 1; // return 0 on success
		}


		void CritSection::Unlock()
		{
			ReleaseMutex(m_mutex);
		}
	}
}


