#include "FInStream.h"
#include <vector>
#include <windows.h>
#include <iostream>
#include <string>

using namespace NS_DM_Client::NS_Common;

FInStream::FInStream()
{}


bool FInStream::Open(String &fileName)
{
	return Open(fileName.c_str());
}


bool FInStream::Open(const char* fileName)
{
    const size_t BUFFER_SIZE  = 32767;
    std::vector<char>  buf;
    buf.resize(BUFFER_SIZE);
    // MSDN: When using ANSI strings, the buffer size should be the string length, plus terminating null character, plus one.
    ::ExpandEnvironmentStringsA(fileName, &buf[0], buf.size() - 2);
    std::string expandedFileName = &buf[0];

    m_ifstream.open(expandedFileName.c_str(), std::ios::in);
    if (!m_ifstream)
    {
        std::cout << "ERROR: Cannot open logfile \"" << std::string(expandedFileName) << std::endl;
        //			throw std::runtime_error((std::string("Cannot create Log file: ") + filename).c_str());
        return false;
    }
    std::cout << "Configuration file is = " << expandedFileName.c_str() << std::endl;
    return true;
}
//-------------------------------------------------------------------------------------------

void FInStream::Close()
{
    m_ifstream.close();
}
//-------------------------------------------------------------------------------------------

bool FInStream::GetLine(String& line)
{
    const int maxLine = 1024;
    char tmpLine[maxLine] = {0};
    m_ifstream.getline(tmpLine, maxLine);
    line = tmpLine;
    return !(m_ifstream.eof());
}
