/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include <base/util/utils.h>
#include <syncml/core/DevInf.h>
#include "common/commontypes.h"
#include "DeviceAdapter/IDeviceAdapter.h"
#include "ManagementObjects/DevInfo.h"
#include "UserAgentFormatter.h"

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_Communication;
    
const char * UserAgentFormatter::m_UserAgent = NULL;

// User-Agent: <make>/<model> MEID/<meid> <DM app vendor>/<DM app version>
const char * UserAgentFormatter::GetUserAgent(ProfileComponentsHolder *pPCH, const char *appvendor, const char *appversion)
{
    if (!m_UserAgent && pPCH)
    {
        FStringBuffer buffer;
        
        DevInfo devInf;
        String man;
        String mod;
        String did;
        pPCH->GetDeviceAdapter()->GetManufacturer(man);
        pPCH->GetDeviceAdapter()->GetModel(mod);
        pPCH->GetDeviceAdapter()->GetDeviceID(did);

        std::transform(did.begin(), did.end(), did.begin(), ::toupper);
        if (man.size() && mod.size())
            buffer.append(man.c_str()).append("/").append(mod.c_str()).append(" ");
        
        buffer.append(did.c_str()).append(" ").append(appvendor).append("/").append(appversion);
        
        m_UserAgent = Funambol::stringdup(buffer.c_str());
    }
    
    return m_UserAgent;
}

