/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "serverexchange/commands/SEMNetworkEntranceCommand.h"

using namespace NS_DM_Client;

SEMNetworkEntranceCommand::SEMNetworkEntranceCommand(IServerExchangeManager &sem, int homeNspID, const char* operatorName, bool startWIB)
	: ServerExchangeCommand(sem), m_homeNspID(homeNspID), m_startWIB(startWIB)
{
	if (operatorName)
	{
		m_operatorName = operatorName;
	}
}

bool SEMNetworkEntranceCommand::Execute()
{
	m_SEM.HandleNetworkEntrance(m_homeNspID, m_operatorName.c_str(), m_startWIB);
	return true;
}
