/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include <syncml/formatter/Formatter.h>
#include <syncml/core/CmdID.h>
#include <syncml/core/Cred.h>
#include "serverexchange/wrappers/SAlertCommand.h"

using namespace NS_DM_Client::NS_SyncMLCommand;


SAlertCommand::SAlertCommand()
{
}


SAlertCommand::SAlertCommand(int data) : m_data(data)
{
}


SAlertCommand::~SAlertCommand()
{
}


void SAlertCommand::createItemizedCommand()
{
    m_ptrItemizedCommand.reset(new Funambol::Alert());
    this_alert()->setData(m_data);
}


Funambol::Alert * SAlertCommand::GetAlert()
{
    return this_alert();
}


int  SAlertCommand::GetData()
{
    return m_data;
}


void SAlertCommand::SetData(int data)
{
    m_data = data;
    if (m_ptrItemizedCommand.get())
    {
        this_alert()->setData(data);
    }
}


void SAlertCommand::AddItem(Funambol::Item &item)
{
    if (this_alert())
    {
        if (!this_alert()->getItems())
        {
            Funambol::ArrayList items;
            this_alert()->setItems(&items);
        }
        this_alert()->getItems()->add(item);
    }
}


Funambol::StringBuffer * SAlertCommand::ToString()
{
    if (m_ptrItemizedCommand.get())
        return Funambol::Formatter::getAlert(this_alert());
    else
        return SCommandAdapter::ToString();
}

