/*
 * Copyright 2010 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "common/identifiers.h"
#include "treemanager/TreeManagerUtils.h"
#include "Logger/LoggerMacroses.h"

const char* const c_LogName = "TreeManagerUtils";
const String s_URI_DMACC(URI_DMACC);

namespace NS_DM_Client
{
namespace TMUtils
{


bool HasAccount(IMOTreeManager &tm, String &serverID)
{
    IMOTreeManager::ChildrenPaths accounts;

    bool found = false;
    if (e_Ok == tm.GetChildren(URI_DMACC, accounts, NULL))
    {
        if (!accounts.empty())
        {
            for (size_t i = 0; i < accounts.size(); ++i)
            {
                IMOTreeManager::ChildrenPaths::const_reference accname = accounts[i];
                String uriAccount(URI_DMACC);
                uriAccount.append("/").append(accname.c_str());

                String curServerID;
                if (GetChildNodeValue(tm, uriAccount, "ServerID", curServerID) && serverID == curServerID)
                {
                    found = true;
                    break;
                }
            }
        }
    }

    return found;
}


void GetFirstAccount(IMOTreeManager &tm, String &serverID)
{
    if (IsDMAccNode(tm, URI_DMACC))
    {
        serverID = URI_DMACC;
    }
    else
    {
        IMOTreeManager::ChildrenPaths accounts;
        if (e_Ok == tm.GetChildren(URI_DMACC, accounts, NULL))
        {
            for (size_t i=0; i<accounts.size(); ++i)
            {
                String uriAccount(URI_DMACC);
                uriAccount.append("/").append(accounts[i].c_str()); // this is uri ./DMAcc/X
                if (IsDMAccNode(tm, uriAccount.c_str()))
                {
                    GetChildNodeValue(tm, uriAccount, "ServerID", serverID);
                    break;
                }
            }
        }
    }
}


bool GetChildNodeValue(IMOTreeManager &tm, const String& uriNode, const char* leafname, String& result)
{
    String uri(uriNode);
    uri.append("/").append(leafname);
    
    return e_Ok == tm.GetValue(uri, result, NULL);
}


bool IsDMAccNode(IMOTreeManager &tm, const char *uri)
{
    String nodeType;
/****
    if (e_Ok == tm.GetPropertyValue(uri, "Type", nodeType, NULL))
    {
        return !strcmp(NODE_TYPE_DMACC, nodeType.c_str());
    }
****/
    StatusCode sc=tm.GetPropertyValue(uri, "Type", nodeType, NULL);
    GDLDEBUG("IsDMAccNode: %s,%d", uri,sc);
    if(sc==e_Ok)
    {
        if(strcmp(NODE_TYPE_DMACC, nodeType.c_str())==0) return true;
        else return false;
    }

    return false;
}


}
}
