#pragma once

#include "DeviceAdapter/IDeviceAdapter.h"

namespace NS_DM_Client
{

	class MockDeviceAdapter : public IDeviceAdapter
	{
	public:
		bool Init(const StringMap& settings, IDaemonEngineRequest* request = 0)
		{
			return true;
		}

		bool Open()
		{
			return true;
		}

		bool Close()
		{
			return true;
		}

		void Release()
		{
			delete this;
		}

		bool GetDeviceInfo(DevInfo& deviceInfo)
		{
			return true;
		}

		bool GetDeviceDetail(DevDetail& deviceDetail)
		{
			return true;
		}

		bool GetDMAccount(DMAcc& dmAccount)
		{
			return true;
		}

		bool GetWiMAX(WiMAX& wimax)
		{
			return true;
		}

		bool GetWiMAXSupp(WiMAXSupp& wimaxSupp)
		{
			return true;
		}

		bool SetDeviceInfo(const DevInfo& deviceInfo)
		{
			return true;
		}

		bool SetDeviceDetail(const DevDetail& deviceDetail)
		{
			return true;
		}

		bool SetDMAccount(const DMAcc& dmAccount)
		{
			return true;
		}

		bool SetWiMAX(const WiMAX& wimax)
		{
			return true;
		}

		bool SetWiMAXSupp(const WiMAXSupp& wimaxSupp)
		{
			return true;
		}

		EnumFirmwareStatus InitFirmwareStorage(const char* packageName = 0, const char* location = 0)
		{
			return IFirmwareUpdater::e_OK;
		}

		EnumFirmwareStatus ResetFirmwareStorage()
		{
			return IFirmwareUpdater::e_OK;
		}

		EnumFirmwareStatus AppendFirmwareChunk(const char* buffer, size_t size, bool last)
		{
			return IFirmwareUpdater::e_OK;
		}

		EnumFirmwareStatus UpdateFirmware()
		{
			return IFirmwareUpdater::e_OK;
		}

		bool GetEMSK(void*, size_t& size)
		{
			return false;
		}

		bool SetEMSK(const void*, size_t size)
		{
			return false;
		}

		bool SetDeviceID(const String& devId)
		{
			return false;
		}

		bool GetDeviceID(String& devId)
		{
			return false;
		}

		bool SetManufacturer(const String& manufacturer)
		{
			return false;
		}

		bool GetManufacturer(String& manufacturer)
		{
			return false;
		}

		bool SetModel(const String& model)
		{
			return false;
		}

		bool GetModel(String& model)
		{
			return false;
		}

		bool GetNetworkInterfaceName(char*, size_t& size)
		{
			return false;
		}

	};
	//-------------------------------------------------------------------------------------------
}
