#include <boost/test/unit_test.hpp>
#include "boost/filesystem/operations.hpp"
#include "boost/filesystem/path.hpp"

#include <iostream>
#include "treemanager/MOTreeManager.h"
#include "../../UTestMOTree/MockDataStorage.h"

#include "Mocks/NotificationCenterMock.h"

#include "serverexchange/wrappers/SCommandAdapter.h"
#include "treemanager/MOTreeAddCommand.h"
#include "treemanager/MOTreeExecCommand.h"

#include <syncml/core/Item.h>
#include <syncml/core/Add.h>
#include <syncml/core/Exec.h>

#include "Common.h"
#include "Errors.h"

//------------------------------------------------------------------------------------------------------
using namespace NS_DM_Client;
//------------------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(MOTreeExecCommand_ExecWithOneItem_failed)
{
    // creation
    Funambol::Exec* exec_command = new Funambol::Exec;
    // initialization with URI
    Funambol::Item* item = new Funambol::Item;
    Funambol::ArrayList* items =  new Funambol::ArrayList;
    Funambol::Target* target = new Funambol::Target("./MOTreeExecCommand_ExecWithOneItem_failed/Item");

    // check notifications
    NS_DM_Client::NotificationCenterMock* notify_center =
        dynamic_cast<NS_DM_Client::NotificationCenterMock*>(S_ProfileHolder->GetNotificationCenter());
    notify_center->clearMockData();

    if (exec_command && item && items && target && S_ProfileHolder)
    {
        item->setTarget(target);

        Funambol::ComplexData data("MOTreeExecCommand_ExecWithOneItem_failed");
        item->setData(&data);
        items->add(*item);
        exec_command->setItems(items);

        ExecPtr ptr(exec_command);

        MOTreeExecCommand command(S_ProfileHolder, ptr, "1", 0);

        BOOST_CHECK(command.Execute() == true);

        // check notifications
        BOOST_CHECK(notify_center->m_mockData.size() == 2); // must be 2 notifications: start and finish
        if (notify_center->m_mockData.size() == 2)
        {
            BOOST_CHECK(notify_center->m_mockData[0].m_URI.compare("./MOTreeExecCommand_ExecWithOneItem_failed/Item") == 0);
            BOOST_CHECK(notify_center->m_mockData[0].m_command == NS_DM_Client::e_Exec);
            BOOST_CHECK(notify_center->m_mockData[0].m_event == NS_DM_Client::e_sessionStart);
            BOOST_CHECK(notify_center->m_mockData[0].m_resultCode == NS_DM_Client::e_Ok);

            BOOST_CHECK(notify_center->m_mockData[1].m_URI.compare("./MOTreeExecCommand_ExecWithOneItem_failed/Item") == 0);
            BOOST_CHECK(notify_center->m_mockData[1].m_command == NS_DM_Client::e_Exec);
            BOOST_CHECK(notify_center->m_mockData[1].m_event == NS_DM_Client::e_sessionEnd);
            BOOST_CHECK(notify_center->m_mockData[1].m_resultCode != NS_DM_Client::e_Ok);
        }

        delete target;
        delete items;
        delete item;
    }
}
