/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#include "treemanager/ServerPollingListener.h"
#include "commontypes.h"
#include "treemanager/IMOTreeManager.h"

#include "SetServerPollerInfoCommand.h"
#include "executionqueue/ExecutionQueue.h"
#include "common/Utils.h"
#include <Logger/LoggerMacroses.h>

const char* const c_LogName = "TreeServerPollingListener";
const size_t listen_uris_count = 3;
const char* listen_uris[listen_uris_count] =
{
    "./WiMAX/DevCap/UpdateMethods/ClientInitiated/PollingAttempts",
    "./WiMAX/DevCap/UpdateMethods/ClientInitiated/PollingInterval",
    "./WiMAX/DevCap/UpdateMethods/ClientInitiated/PollingSupported"
};

namespace NS_DM_Client
{
    TreeServerPollingListener::TreeServerPollingListener(ProfileComponentsHolder& pch): m_component_holder(pch)
    {

    }

//-------------------------------------------------------------------------------------------
bool TreeServerPollingListener::Init(ProfileComponentsHolder& pch)
{
    return true;
}
//-------------------------------------------------------------------------------------------
bool TreeServerPollingListener::Release()
{
    delete this;
    return true;
}
//-------------------------------------------------------------------------------------------
bool TreeServerPollingListener::ExecuteOnAdd(const URI& uri)
{
    if (isListenURI(uri))
    {
        notifyExchangeServer(uri);
    }
    return true;
}
//-------------------------------------------------------------------------------------------
bool TreeServerPollingListener::ExecuteOnDelete(const URI& uri)
{
    if (isListenURI(uri))
    {
        notifyExchangeServer(uri);
    }
    return true;
}
//-------------------------------------------------------------------------------------------
bool TreeServerPollingListener::ExecuteOnReplace(const URI& uri)
{
    if (isListenURI(uri))
    {
        notifyExchangeServer(uri);
    }
    return true;
}
//-------------------------------------------------------------------------------------------
bool TreeServerPollingListener::ExecuteOnReplaceProperty(const URI& uri, const String& property_name)
{
    return true;
}
//-------------------------------------------------------------------------------------------
bool TreeServerPollingListener::ExecuteOnCopy(const URI& source, const URI& dest)
{
    return true;
}
//-------------------------------------------------------------------------------------------
bool TreeServerPollingListener::isListenURI(const URI& uri)
{
    for (size_t i = 0; i < listen_uris_count; ++i)
    {
        if (uri.compare(listen_uris[i]) == 0)
        {
            return true;
        }
    }
    return false;
}
//-------------------------------------------------------------------------------------------
bool TreeServerPollingListener::notifyExchangeServer(const URI& uri)
{
    bool pollingSupported = false;
    int pollingInterval = 0;
    int pollingAttempts = 0;
    String value;

    if ((!m_component_holder.GetMOTreeManager()) || (!m_component_holder.GetExecutionQueue()))
    {
        return false;
    }

    if (m_component_holder.GetMOTreeManager()->GetValue(listen_uris[0], value)) // PollingAttempts
    {
        sscanf(value.c_str(), "%d", &pollingAttempts);
    }
    else
    {
        pollingAttempts = 0;
    }

    if (m_component_holder.GetMOTreeManager()->GetValue(listen_uris[1], value)) // PollingInterval
    {
        sscanf(value.c_str(), "%d", &pollingInterval);
    }
    else
    {
        pollingInterval = 0;
    }
    if (m_component_holder.GetMOTreeManager()->GetValue(listen_uris[2], value)) // PollingSupported
    {
        if (IsBooleanTrue(value))
        {
            pollingSupported = true;
        }
    }
    else
    {
        pollingSupported = false;
    }

    SetServerPollerInfoCommand* pollerCommand = new(std::nothrow) SetServerPollerInfoCommand(*m_component_holder.GetServerExchangeManager(), pollingSupported, pollingInterval, pollingAttempts);
    if(pollerCommand == (SetServerPollerInfoCommand*)NULL)
    {
        GDLWARN("new SetServerPollerInfoCommand");
    }

    IExecutionQueue* queue = m_component_holder.GetExecutionQueue();
    if (queue != (IExecutionQueue*)NULL)
    {
        queue->Add(*pollerCommand);
    }
    return true;
}
//-------------------------------------------------------------------------------------------
}
