/*
 * Decompiled with CFR 0.152.
 */
package fuse;

import fuse.Filesystem3;
import fuse.Filesystem3ToFuseFSAdapter;
import fuse.FuseFS;
import fuse.compat.Filesystem1;
import fuse.compat.Filesystem1ToFilesystem2Adapter;
import fuse.compat.Filesystem2;
import fuse.compat.Filesystem2ToFilesystem3Adapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FuseMount {
    private static final Log log = LogFactory.getLog(FuseMount.class);

    private FuseMount() {
    }

    public static void mount(String[] args, Filesystem1 filesystem1) throws Exception {
        FuseMount.mount(args, new Filesystem2ToFilesystem3Adapter(new Filesystem1ToFilesystem2Adapter(filesystem1)), LogFactory.getLog(filesystem1.getClass()));
    }

    public static void mount(String[] args, Filesystem2 filesystem2) throws Exception {
        FuseMount.mount(args, new Filesystem2ToFilesystem3Adapter(filesystem2), LogFactory.getLog(filesystem2.getClass()));
    }

    public static void mount(String[] args, Filesystem3 filesystem3, Log log) throws Exception {
        FuseMount.mount(args, new Filesystem3ToFuseFSAdapter(filesystem3, log));
    }

    public static void mount(String[] args, FuseFS fuseFS) throws Exception {
        ThreadGroup threadGroup = new ThreadGroup(Thread.currentThread().getThreadGroup(), "FUSE Threads");
        threadGroup.setDaemon(true);
        log.info((Object)"Mounting filesystem");
        FuseMount.mount(args, fuseFS, threadGroup);
        log.info((Object)"Filesystem is unmounted");
        if (log.isDebugEnabled()) {
            int n = threadGroup.activeCount();
            log.debug((Object)("ThreadGroup(\"" + threadGroup.getName() + "\").activeCount() = " + n));
            Thread[] threads = new Thread[n];
            threadGroup.enumerate(threads);
            for (int i = 0; i < threads.length; ++i) {
                log.debug((Object)("thread[" + i + "] = " + threads[i] + ", isDaemon = " + threads[i].isDaemon()));
            }
        }
    }

    private static native void mount(String[] var0, FuseFS var1, ThreadGroup var2) throws Exception;

    static {
        System.loadLibrary("javafs");
    }
}

