/*
 * Decompiled with CFR 0.152.
 */
package fuse.zipfs;

import fuse.FuseException;
import fuse.FuseMount;
import fuse.FuseStatfs;
import fuse.compat.Filesystem1;
import fuse.compat.FuseDirEnt;
import fuse.compat.FuseStat;
import fuse.zipfs.ZipEntryDataReader;
import fuse.zipfs.ZipFileDataReader;
import fuse.zipfs.util.Node;
import fuse.zipfs.util.Tree;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZipFilesystem
implements Filesystem1 {
    private static final Log log = LogFactory.getLog(ZipFilesystem.class);
    private static final int blockSize = 512;
    private ZipFile zipFile;
    private long zipFileTime;
    private ZipEntry rootEntry;
    private Tree tree;
    private FuseStatfs statfs;
    private ZipFileDataReader zipFileDataReader;

    public ZipFilesystem(File file) throws IOException {
        log.info((Object)"extracting zip file structure...");
        this.zipFile = new ZipFile(file, 1);
        this.zipFileTime = file.lastModified();
        this.rootEntry = new ZipEntry(""){

            public boolean isDirectory() {
                return true;
            }
        };
        this.rootEntry.setTime(this.zipFileTime);
        this.rootEntry.setSize(0L);
        this.zipFileDataReader = new ZipFileDataReader(this.zipFile);
        this.tree = new Tree();
        this.tree.addNode(this.rootEntry.getName(), this.rootEntry);
        int files = 0;
        int dirs = 0;
        int blocks = 0;
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            this.tree.addNode(entry.getName(), entry);
            if (entry.isDirectory()) {
                ++dirs;
            } else {
                ++files;
            }
            blocks = (int)((long)blocks + (entry.getSize() + 512L - 1L) / 512L);
        }
        this.statfs = new FuseStatfs();
        this.statfs.blocks = blocks;
        this.statfs.blockSize = 512;
        this.statfs.blocksFree = 0;
        this.statfs.files = files + dirs;
        this.statfs.filesFree = 0;
        this.statfs.namelen = 2048;
        log.info((Object)("zip file structure extracted: " + files + " files, " + dirs + " directories, " + blocks + " blocks (" + 512 + " byte/block)."));
    }

    public void chmod(String path, int mode) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    public void chown(String path, int uid, int gid) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    public FuseStat getattr(String path) throws FuseException {
        Node node = this.tree.lookupNode(path);
        ZipEntry entry = null;
        if (node == null || (entry = (ZipEntry)node.getValue()) == null) {
            throw new FuseException("No Such Entry").initErrno(2);
        }
        FuseStat stat = new FuseStat();
        stat.mode = entry.isDirectory() ? 16877 : 33188;
        stat.nlink = 1;
        stat.uid = 0;
        stat.gid = 0;
        stat.size = entry.getSize();
        stat.mtime = stat.ctime = (int)(entry.getTime() / 1000L);
        stat.atime = stat.ctime;
        stat.blocks = (int)((stat.size + 511L) / 512L);
        return stat;
    }

    public FuseDirEnt[] getdir(String path) throws FuseException {
        Node node = this.tree.lookupNode(path);
        ZipEntry entry = null;
        if (node == null || (entry = (ZipEntry)node.getValue()) == null) {
            throw new FuseException("No Such Entry").initErrno(2);
        }
        if (!entry.isDirectory()) {
            throw new FuseException("Not A Directory").initErrno(20);
        }
        Collection children = node.getChildren();
        FuseDirEnt[] dirEntries = new FuseDirEnt[children.size()];
        int i = 0;
        for (Node childNode : children) {
            FuseDirEnt dirEntry;
            ZipEntry zipEntry = (ZipEntry)childNode.getValue();
            dirEntries[i] = dirEntry = new FuseDirEnt();
            dirEntry.name = childNode.getName();
            dirEntry.mode = zipEntry.isDirectory() ? 16384 : 32768;
            ++i;
        }
        return dirEntries;
    }

    public void link(String from, String to) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    public void mkdir(String path, int mode) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    public void mknod(String path, int mode, int rdev) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    public void open(String path, int flags) throws FuseException {
        ZipEntry entry = this.getFileZipEntry(path);
        if (flags == 1 || flags == 2) {
            throw new FuseException("Read Only").initErrno(13);
        }
    }

    public void rename(String from, String to) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    public void rmdir(String path) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    public FuseStatfs statfs() throws FuseException {
        return this.statfs;
    }

    public void symlink(String from, String to) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    public void truncate(String path, long size) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    public void unlink(String path) throws FuseException {
        throw new FuseException("Read Only").initErrno(13);
    }

    public void utime(String path, int atime, int mtime) throws FuseException {
    }

    public String readlink(String path) throws FuseException {
        throw new FuseException("Not a link").initErrno(2);
    }

    public void write(String path, ByteBuffer buf, long offset) throws FuseException {
    }

    public void read(String path, ByteBuffer buf, long offset) throws FuseException {
        ZipEntry zipEntry = this.getFileZipEntry(path);
        ZipEntryDataReader reader = this.zipFileDataReader.getZipEntryDataReader(zipEntry, offset, buf.capacity());
        reader.read(buf, offset);
    }

    public void release(String path, int flags) throws FuseException {
        ZipEntry zipEntry = this.getFileZipEntry(path);
        this.zipFileDataReader.releaseZipEntryDataReader(zipEntry);
    }

    private ZipEntry getFileZipEntry(String path) throws FuseException {
        ZipEntry entry;
        Node node = this.tree.lookupNode(path);
        if (node == null || (entry = (ZipEntry)node.getValue()) == null) {
            throw new FuseException("No Such Entry").initErrno(2);
        }
        if (entry.isDirectory()) {
            throw new FuseException("Not A File").initErrno(2);
        }
        return entry;
    }

    private ZipEntry getDirectoryZipEntry(String path) throws FuseException {
        ZipEntry entry;
        Node node = this.tree.lookupNode(path);
        if (node == null || (entry = (ZipEntry)node.getValue()) == null) {
            throw new FuseException("No Such Entry").initErrno(2);
        }
        if (!entry.isDirectory()) {
            throw new FuseException("Not A Directory").initErrno(2);
        }
        return entry;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Must specify ZIP file");
            System.exit(-1);
        }
        String[] fuseArgs = new String[args.length - 1];
        System.arraycopy(args, 0, fuseArgs, 0, fuseArgs.length);
        File zipFile = new File(args[args.length - 1]);
        try {
            FuseMount.mount(fuseArgs, new ZipFilesystem(zipFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

