/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlockListAsLongs
implements Iterable<Block> {
    private static final int LONGS_PER_FINALIZED_BLOCK = 3;
    private static final int LONGS_PER_UC_BLOCK = 4;
    private static final int HEADER_SIZE = 2;
    private long[] blockList;
    public static final String __PARANAMER_DATA = "<init> java.util.List,java.util.List finalized,uc \n<init> long[] iBlockList \ngetBlockGenStamp int index \ngetBlockId int index \ngetBlockLen int index \n";

    private int index2BlockId(int blockIndex) {
        if (blockIndex < 0 || blockIndex > this.getNumberOfBlocks()) {
            return -1;
        }
        int finalizedSize = this.getNumberOfFinalizedReplicas();
        if (blockIndex < finalizedSize) {
            return 2 + blockIndex * 3;
        }
        return 2 + (finalizedSize + 1) * 3 + (blockIndex - finalizedSize) * 4;
    }

    public BlockListAsLongs(List<? extends Block> finalized, List<ReplicaInfo> uc) {
        int i;
        int finalizedSize = finalized == null ? 0 : finalized.size();
        int ucSize = uc == null ? 0 : uc.size();
        int len = 2 + (finalizedSize + 1) * 3 + ucSize * 4;
        this.blockList = new long[len];
        this.blockList[0] = finalizedSize;
        this.blockList[1] = ucSize;
        for (i = 0; i < finalizedSize; ++i) {
            this.setBlock(i, finalized.get(i));
        }
        this.setDelimitingBlock(finalizedSize);
        for (i = 0; i < ucSize; ++i) {
            this.setBlock(finalizedSize + i, (Block)uc.get(i));
        }
    }

    public BlockListAsLongs() {
        this(null);
    }

    public BlockListAsLongs(long[] iBlockList) {
        if (iBlockList == null) {
            this.blockList = new long[2];
            return;
        }
        this.blockList = iBlockList;
    }

    public long[] getBlockListAsLongs() {
        return this.blockList;
    }

    @Override
    public Iterator<Block> iterator() {
        return this.getBlockReportIterator();
    }

    public BlockReportIterator getBlockReportIterator() {
        return new BlockReportIterator();
    }

    public int getNumberOfBlocks() {
        assert ((long)this.blockList.length == 2L + (this.blockList[0] + 1L) * 3L + this.blockList[1] * 4L) : "Number of blocks is inconcistent with the array length";
        return this.getNumberOfFinalizedReplicas() + this.getNumberOfUCReplicas();
    }

    private int getNumberOfFinalizedReplicas() {
        return (int)this.blockList[0];
    }

    private int getNumberOfUCReplicas() {
        return (int)this.blockList[1];
    }

    private long blockId(int index) {
        return this.blockList[this.index2BlockId(index)];
    }

    private long blockLength(int index) {
        return this.blockList[this.index2BlockId(index) + 1];
    }

    private long blockGenerationStamp(int index) {
        return this.blockList[this.index2BlockId(index) + 2];
    }

    private HdfsConstants.ReplicaState blockReplicaState(int index) {
        if (index < this.getNumberOfFinalizedReplicas()) {
            return HdfsConstants.ReplicaState.FINALIZED;
        }
        return HdfsConstants.ReplicaState.getState((int)this.blockList[this.index2BlockId(index) + 3]);
    }

    @Deprecated
    public long getBlockId(int index) {
        return this.blockId(index);
    }

    @Deprecated
    public long getBlockLen(int index) {
        return this.blockLength(index);
    }

    @Deprecated
    public long getBlockGenStamp(int index) {
        return this.blockGenerationStamp(index);
    }

    private <T extends Block> void setBlock(int index, T b) {
        int pos = this.index2BlockId(index);
        this.blockList[pos] = b.getBlockId();
        this.blockList[pos + 1] = b.getNumBytes();
        this.blockList[pos + 2] = b.getGenerationStamp();
        if (index < this.getNumberOfFinalizedReplicas()) {
            return;
        }
        assert (((ReplicaInfo)b).getState() != HdfsConstants.ReplicaState.FINALIZED) : "Must be under-construction replica.";
        this.blockList[pos + 3] = ((ReplicaInfo)b).getState().getValue();
    }

    private void setDelimitingBlock(int finalizedSzie) {
        int idx = 2 + finalizedSzie * 3;
        this.blockList[idx] = -1L;
        this.blockList[idx + 1] = -1L;
        this.blockList[idx + 2] = -1L;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public class BlockReportIterator
    implements Iterator<Block> {
        private int currentBlockIndex = 0;
        private Block block = new Block();
        private HdfsConstants.ReplicaState currentReplicaState = null;
        public static final String __PARANAMER_DATA = "";

        BlockReportIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentBlockIndex < BlockListAsLongs.this.getNumberOfBlocks();
        }

        @Override
        public Block next() {
            this.block.set(BlockListAsLongs.this.blockId(this.currentBlockIndex), BlockListAsLongs.this.blockLength(this.currentBlockIndex), BlockListAsLongs.this.blockGenerationStamp(this.currentBlockIndex));
            this.currentReplicaState = BlockListAsLongs.this.blockReplicaState(this.currentBlockIndex);
            ++this.currentBlockIndex;
            return this.block;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Sorry. can't remove.");
        }

        public HdfsConstants.ReplicaState getCurrentReplicaState() {
            return this.currentReplicaState;
        }
    }
}

