/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.BlockTransferThrottler;
import org.apache.hadoop.hdfs.server.datanode.ChunkChecksum;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetInterface;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBeingWritten;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipeline;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.SocketOutputStream;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.StringUtils;

class BlockSender
implements Closeable,
FSConstants {
    public static final Log LOG = DataNode.LOG;
    static final Log ClientTraceLog = DataNode.ClientTraceLog;
    private Block block;
    private final Replica replica;
    private final long replicaVisibleLength;
    private InputStream blockIn;
    private long blockInPosition = -1L;
    private DataInputStream checksumIn;
    private DataChecksum checksum;
    private long offset;
    private long endOffset;
    private int bytesPerChecksum;
    private int checksumSize;
    private boolean corruptChecksumOk;
    private boolean chunkOffsetOK;
    private long seqno;
    private boolean transferToAllowed = true;
    private boolean blockReadFully;
    private boolean verifyChecksum;
    private BlockTransferThrottler throttler;
    private final String clientTraceFmt;
    private static final int MIN_BUFFER_WITH_TRANSFERTO = 65536;
    private volatile ChunkChecksum lastChunkChecksum = null;

    BlockSender(Block block, long startOffset, long length, boolean corruptChecksumOk, boolean chunkOffsetOK, boolean verifyChecksum, DataNode datanode) throws IOException {
        this(block, startOffset, length, corruptChecksumOk, chunkOffsetOK, verifyChecksum, datanode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BlockSender(Block block, long startOffset, long length, boolean corruptChecksumOk, boolean chunkOffsetOK, boolean verifyChecksum, DataNode datanode, String clientTraceFmt) throws IOException {
        try {
            long checksumSkip;
            this.block = block;
            FSDatasetInterface fSDatasetInterface = datanode.data;
            synchronized (fSDatasetInterface) {
                this.replica = datanode.data.getReplica(block.getBlockId());
                if (this.replica == null) {
                    throw new ReplicaNotFoundException(block);
                }
                this.replicaVisibleLength = this.replica.getVisibleLength();
            }
            long minEndOffset = startOffset + length;
            ChunkChecksum chunkChecksum = null;
            if (this.replica instanceof ReplicaBeingWritten) {
                for (int i = 0; i < 30 && this.replica.getBytesOnDisk() < minEndOffset; ++i) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        throw new IOException(ie);
                    }
                }
                long currentBytesOnDisk = this.replica.getBytesOnDisk();
                if (currentBytesOnDisk < minEndOffset) {
                    throw new IOException(String.format("need %d bytes, but only %d bytes available", minEndOffset, currentBytesOnDisk));
                }
                ReplicaInPipeline rip = (ReplicaInPipeline)this.replica;
                chunkChecksum = rip.getLastChecksumAndDataLen();
            }
            if (this.replica.getGenerationStamp() < block.getGenerationStamp()) {
                throw new IOException("replica.getGenerationStamp() < block.getGenerationStamp(), block=" + block + ", replica=" + this.replica);
            }
            if (this.replicaVisibleLength < 0L) {
                throw new IOException("The replica is not readable, block=" + block + ", replica=" + this.replica);
            }
            if (DataNode.LOG.isDebugEnabled()) {
                DataNode.LOG.debug((Object)("block=" + block + ", replica=" + this.replica));
            }
            this.chunkOffsetOK = chunkOffsetOK;
            this.corruptChecksumOk = corruptChecksumOk;
            this.verifyChecksum = verifyChecksum;
            this.transferToAllowed = datanode.transferToAllowed;
            this.clientTraceFmt = clientTraceFmt;
            if (!corruptChecksumOk || datanode.data.metaFileExists(block)) {
                this.checksumIn = new DataInputStream(new BufferedInputStream(datanode.data.getMetaDataInputStream(block), BUFFER_SIZE));
                BlockMetadataHeader header = BlockMetadataHeader.readHeader(this.checksumIn);
                short version = header.getVersion();
                if (version != 1) {
                    LOG.warn((Object)("Wrong version (" + version + ") for metadata file for " + block + " ignoring ..."));
                }
                this.checksum = header.getChecksum();
            } else {
                LOG.warn((Object)("Could not find metadata file for " + block));
                this.checksum = DataChecksum.newDataChecksum((int)0, (int)16384);
            }
            this.bytesPerChecksum = this.checksum.getBytesPerChecksum();
            if (this.bytesPerChecksum > 0xA00000 && (long)this.bytesPerChecksum > this.replicaVisibleLength) {
                this.checksum = DataChecksum.newDataChecksum((int)this.checksum.getChecksumType(), (int)Math.max((int)this.replicaVisibleLength, 0xA00000));
                this.bytesPerChecksum = this.checksum.getBytesPerChecksum();
            }
            this.checksumSize = this.checksum.getChecksumSize();
            if (length < 0L) {
                length = this.replicaVisibleLength;
            }
            this.endOffset = chunkChecksum != null ? chunkChecksum.getDataLength() : this.replica.getBytesOnDisk();
            if (startOffset < 0L || startOffset > this.endOffset || length + startOffset > this.endOffset) {
                String msg = " Offset " + startOffset + " and length " + length + " don't match block " + block + " ( blockLen " + this.endOffset + " )";
                LOG.warn((Object)(datanode.dnRegistration + ":sendBlock() : " + msg));
                throw new IOException(msg);
            }
            this.offset = startOffset - startOffset % (long)this.bytesPerChecksum;
            if (length >= 0L) {
                long tmpLen = startOffset + length;
                if (tmpLen % (long)this.bytesPerChecksum != 0L) {
                    tmpLen += (long)this.bytesPerChecksum - tmpLen % (long)this.bytesPerChecksum;
                }
                if (tmpLen < this.endOffset) {
                    this.endOffset = tmpLen;
                } else if (chunkChecksum != null) {
                    this.lastChunkChecksum = chunkChecksum;
                }
            }
            if (this.offset > 0L && (checksumSkip = this.offset / (long)this.bytesPerChecksum * (long)this.checksumSize) > 0L) {
                IOUtils.skipFully((InputStream)this.checksumIn, (long)checksumSkip);
            }
            this.seqno = 0L;
            if (DataNode.LOG.isDebugEnabled()) {
                DataNode.LOG.debug((Object)("replica=" + this.replica));
            }
            this.blockIn = datanode.data.getBlockInputStream(block, this.offset);
        }
        catch (IOException ioe) {
            IOUtils.closeStream((Closeable)this);
            IOUtils.closeStream((Closeable)this.blockIn);
            throw ioe;
        }
    }

    @Override
    public void close() throws IOException {
        IOException ioe = null;
        if (this.checksumIn != null) {
            try {
                this.checksumIn.close();
            }
            catch (IOException e) {
                ioe = e;
            }
            this.checksumIn = null;
        }
        if (this.blockIn != null) {
            try {
                this.blockIn.close();
            }
            catch (IOException e) {
                ioe = e;
            }
            this.blockIn = null;
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    private static IOException ioeToSocketException(IOException ioe) {
        if (ioe.getClass().equals(IOException.class)) {
            SocketException se = new SocketException("Original Exception : " + ioe);
            se.initCause(ioe);
            se.setStackTrace(ioe.getStackTrace());
            return se;
        }
        return ioe;
    }

    private int sendChunks(ByteBuffer pkt, int maxChunks, OutputStream out) throws IOException {
        int len = Math.min((int)(this.endOffset - this.offset), this.bytesPerChecksum * maxChunks);
        int numChunks = (len + this.bytesPerChecksum - 1) / this.bytesPerChecksum;
        int packetLen = len + numChunks * this.checksumSize + 4;
        boolean lastDataPacket = this.offset + (long)len == this.endOffset && len > 0;
        pkt.clear();
        pkt.putInt(packetLen);
        pkt.putLong(this.offset);
        pkt.putLong(this.seqno);
        pkt.put((byte)(len == 0 ? 1 : 0));
        pkt.putInt(len);
        int checksumOff = pkt.position();
        int checksumLen = numChunks * this.checksumSize;
        byte[] buf = pkt.array();
        if (this.checksumSize > 0 && this.checksumIn != null) {
            try {
                this.checksumIn.readFully(buf, checksumOff, checksumLen);
            }
            catch (IOException e) {
                LOG.warn((Object)(" Could not read or failed to veirfy checksum for data at offset " + this.offset + " for block " + this.block + " got : " + StringUtils.stringifyException((Throwable)e)));
                IOUtils.closeStream((Closeable)this.checksumIn);
                this.checksumIn = null;
                if (this.corruptChecksumOk) {
                    if (checksumOff < checksumLen) {
                        Arrays.fill(buf, checksumOff, checksumLen, (byte)0);
                    }
                }
                throw e;
            }
            if (lastDataPacket && this.lastChunkChecksum != null) {
                int start = checksumOff + checksumLen - this.checksumSize;
                byte[] updatedChecksum = this.lastChunkChecksum.getChecksum();
                if (updatedChecksum != null) {
                    System.arraycopy(updatedChecksum, 0, buf, start, this.checksumSize);
                }
            }
        }
        int dataOff = checksumOff + checksumLen;
        if (this.blockInPosition < 0L) {
            IOUtils.readFully((InputStream)this.blockIn, (byte[])buf, (int)dataOff, (int)len);
            if (this.verifyChecksum) {
                int dOff = dataOff;
                int cOff = checksumOff;
                int dLeft = len;
                for (int i = 0; i < numChunks; ++i) {
                    this.checksum.reset();
                    int dLen = Math.min(dLeft, this.bytesPerChecksum);
                    this.checksum.update(buf, dOff, dLen);
                    if (!this.checksum.compare(buf, cOff)) {
                        long failedPos = this.offset + (long)len - (long)dLeft;
                        throw new ChecksumException("Checksum failed at " + failedPos, failedPos);
                    }
                    dLeft -= dLen;
                    dOff += dLen;
                    cOff += this.checksumSize;
                }
            }
        }
        try {
            if (this.blockInPosition >= 0L) {
                SocketOutputStream sockOut = (SocketOutputStream)out;
                sockOut.write(buf, 0, dataOff);
                sockOut.transferToFully(((FileInputStream)this.blockIn).getChannel(), this.blockInPosition, len);
                this.blockInPosition += (long)len;
            } else {
                out.write(buf, 0, dataOff + len);
            }
        }
        catch (IOException e) {
            throw BlockSender.ioeToSocketException(e);
        }
        if (this.throttler != null) {
            this.throttler.throttle(packetLen);
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long sendBlock(DataOutputStream out, OutputStream baseStream, BlockTransferThrottler throttler) throws IOException {
        long totalRead;
        long initialOffset;
        block12: {
            if (out == null) {
                throw new IOException("out stream is null");
            }
            this.throttler = throttler;
            initialOffset = this.offset;
            totalRead = 0L;
            DataOutputStream dataOutputStream = out;
            long startTime = ClientTraceLog.isInfoEnabled() ? System.nanoTime() : 0L;
            try {
                void var8_8;
                int maxChunksPerPacket;
                try {
                    this.checksum.writeHeader(out);
                    if (this.chunkOffsetOK) {
                        out.writeLong(this.offset);
                    }
                    out.flush();
                }
                catch (IOException e) {
                    throw BlockSender.ioeToSocketException(e);
                }
                int pktSize = 25;
                if (this.transferToAllowed && !this.verifyChecksum && baseStream instanceof SocketOutputStream && this.blockIn instanceof FileInputStream) {
                    FileChannel fileChannel = ((FileInputStream)this.blockIn).getChannel();
                    this.blockInPosition = fileChannel.position();
                    OutputStream outputStream = baseStream;
                    maxChunksPerPacket = (Math.max(BUFFER_SIZE, 65536) + this.bytesPerChecksum - 1) / this.bytesPerChecksum;
                    pktSize += this.checksumSize * maxChunksPerPacket;
                } else {
                    maxChunksPerPacket = Math.max(1, (BUFFER_SIZE + this.bytesPerChecksum - 1) / this.bytesPerChecksum);
                    pktSize += (this.bytesPerChecksum + this.checksumSize) * maxChunksPerPacket;
                }
                ByteBuffer pktBuf = ByteBuffer.allocate(pktSize);
                while (this.endOffset > this.offset) {
                    long len = this.sendChunks(pktBuf, maxChunksPerPacket, (OutputStream)var8_8);
                    this.offset += len;
                    totalRead += len + (len + (long)this.bytesPerChecksum - 1L) / (long)this.bytesPerChecksum * (long)this.checksumSize;
                    ++this.seqno;
                }
                try {
                    this.sendChunks(pktBuf, maxChunksPerPacket, (OutputStream)var8_8);
                    out.flush();
                }
                catch (IOException e) {
                    throw BlockSender.ioeToSocketException(e);
                }
                if (this.clientTraceFmt == null) break block12;
            }
            catch (Throwable throwable) {
                if (this.clientTraceFmt != null) {
                    long endTime = System.nanoTime();
                    ClientTraceLog.info((Object)String.format(this.clientTraceFmt, totalRead, initialOffset, endTime - startTime));
                }
                this.close();
                throw throwable;
            }
            long endTime = System.nanoTime();
            ClientTraceLog.info((Object)String.format(this.clientTraceFmt, totalRead, initialOffset, endTime - startTime));
        }
        this.close();
        this.blockReadFully = initialOffset == 0L && this.offset >= this.replicaVisibleLength;
        return totalRead;
    }

    boolean isBlockReadFully() {
        return this.blockReadFully;
    }
}

