/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipelineInterface;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.metrics.FSDatasetMBean;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.DiskChecker;

@InterfaceAudience.Private
public interface FSDatasetInterface
extends FSDatasetMBean {
    public long getMetaDataLength(Block var1) throws IOException;

    public MetaDataInputStream getMetaDataInputStream(Block var1) throws IOException;

    public boolean metaFileExists(Block var1) throws IOException;

    public long getLength(Block var1) throws IOException;

    @Deprecated
    public Replica getReplica(long var1);

    public Block getStoredBlock(long var1) throws IOException;

    public InputStream getBlockInputStream(Block var1) throws IOException;

    public InputStream getBlockInputStream(Block var1, long var2) throws IOException;

    public BlockInputStreams getTmpInputStreams(Block var1, long var2, long var4) throws IOException;

    public ReplicaInPipelineInterface createTemporary(Block var1) throws IOException;

    public ReplicaInPipelineInterface createRbw(Block var1) throws IOException;

    public ReplicaInPipelineInterface recoverRbw(Block var1, long var2, long var4, long var6) throws IOException;

    public ReplicaInPipelineInterface append(Block var1, long var2, long var4) throws IOException;

    public ReplicaInPipelineInterface recoverAppend(Block var1, long var2, long var4) throws IOException;

    public void recoverClose(Block var1, long var2, long var4) throws IOException;

    public void finalizeBlock(Block var1) throws IOException;

    public void unfinalizeBlock(Block var1) throws IOException;

    public BlockListAsLongs getBlockReport();

    public boolean isValidBlock(Block var1);

    public void invalidate(Block[] var1) throws IOException;

    public void checkDataDir() throws DiskChecker.DiskErrorException;

    public String toString();

    public void shutdown();

    public void adjustCrcChannelPosition(Block var1, BlockWriteStreams var2, int var3) throws IOException;

    public boolean hasEnoughResource();

    public long getReplicaVisibleLength(Block var1) throws IOException;

    public ReplicaRecoveryInfo initReplicaRecovery(BlockRecoveryCommand.RecoveringBlock var1) throws IOException;

    public ReplicaInfo updateReplicaUnderRecovery(Block var1, long var2, long var4) throws IOException;

    public static class BlockInputStreams
    implements Closeable {
        final InputStream dataIn;
        final InputStream checksumIn;

        BlockInputStreams(InputStream dataIn, InputStream checksumIn) {
            this.dataIn = dataIn;
            this.checksumIn = checksumIn;
        }

        @Override
        public void close() {
            IOUtils.closeStream((Closeable)this.dataIn);
            IOUtils.closeStream((Closeable)this.checksumIn);
        }
    }

    public static class BlockWriteStreams {
        OutputStream dataOut;
        OutputStream checksumOut;

        BlockWriteStreams(OutputStream dOut, OutputStream cOut) {
            this.dataOut = dOut;
            this.checksumOut = cOut;
        }

        void close() throws IOException {
            IOUtils.closeStream((Closeable)this.dataOut);
            IOUtils.closeStream((Closeable)this.checksumOut);
        }
    }

    public static class MetaDataInputStream
    extends FilterInputStream {
        private long length;

        MetaDataInputStream(InputStream stream, long len) {
            super(stream);
            this.length = len;
        }

        public long getLength() {
            return this.length;
        }
    }
}

