/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.BackupNode;
import org.apache.hadoop.hdfs.server.namenode.BackupStorage;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.GetImageServlet;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.server.protocol.CheckpointCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.util.Daemon;

class Checkpointer
extends Daemon {
    public static final Log LOG = LogFactory.getLog((String)Checkpointer.class.getName());
    private BackupNode backupNode;
    volatile boolean shouldRun;
    private long checkpointPeriod;
    private long checkpointSize;

    private BackupStorage getFSImage() {
        return (BackupStorage)this.backupNode.getFSImage();
    }

    private NamenodeProtocol getNamenode() {
        return this.backupNode.namenode;
    }

    Checkpointer(Configuration conf, BackupNode bnNode) throws IOException {
        this.backupNode = bnNode;
        try {
            this.initialize(conf);
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
    }

    private void initialize(Configuration conf) throws IOException {
        this.shouldRun = true;
        this.checkpointPeriod = conf.getLong("dfs.namenode.checkpoint.period", 3600L);
        this.checkpointSize = conf.getLong("dfs.namenode.checkpoint.size", 0x400000L);
        HttpServer httpServer = this.backupNode.httpServer;
        httpServer.setAttribute("name.system.image", (Object)this.getFSImage());
        httpServer.setAttribute("name.conf", (Object)conf);
        httpServer.addInternalServlet("getimage", "/getimage", GetImageServlet.class);
        LOG.info((Object)("Checkpoint Period : " + this.checkpointPeriod + " secs " + "(" + this.checkpointPeriod / 60L + " min)"));
        LOG.info((Object)("Log Size Trigger  : " + this.checkpointSize + " bytes " + "(" + this.checkpointSize / 1024L + " KB)"));
    }

    void shutdown() {
        this.shouldRun = false;
        this.backupNode.stop();
    }

    public void run() {
        long periodMSec = 300L;
        if (this.checkpointPeriod < periodMSec) {
            periodMSec = this.checkpointPeriod;
        }
        periodMSec *= 1000L;
        long lastCheckpointTime = 0L;
        if (!this.backupNode.shouldCheckpointAtStartup()) {
            lastCheckpointTime = FSNamesystem.now();
        }
        while (this.shouldRun) {
            block11: {
                try {
                    long now = FSNamesystem.now();
                    boolean shouldCheckpoint = false;
                    if (now >= lastCheckpointTime + periodMSec) {
                        shouldCheckpoint = true;
                    } else {
                        long size = this.getJournalSize();
                        if (size >= this.checkpointSize) {
                            shouldCheckpoint = true;
                        }
                    }
                    if (!shouldCheckpoint) break block11;
                    this.doCheckpoint();
                    lastCheckpointTime = now;
                }
                catch (IOException e) {
                    LOG.error((Object)"Exception in doCheckpoint: ", (Throwable)e);
                }
                catch (Throwable e) {
                    LOG.error((Object)"Throwable Exception in doCheckpoint: ", e);
                    this.shutdown();
                    break;
                }
            }
            try {
                Thread.sleep(periodMSec);
            }
            catch (InterruptedException ie) {}
        }
    }

    private long getJournalSize() throws IOException {
        if (this.backupNode.isRole(HdfsConstants.NamenodeRole.BACKUP) && this.getFSImage().getEditLog().isOpen()) {
            return this.backupNode.journalSize();
        }
        return this.getNamenode().journalSize(this.backupNode.getRegistration());
    }

    private void downloadCheckpoint(CheckpointSignature sig) throws IOException {
        String fileid = "getimage=1";
        Collection<File> list = this.getFSImage().getFiles(FSImage.NameNodeFile.IMAGE, FSImage.NameNodeDirType.IMAGE);
        File[] files = list.toArray(new File[list.size()]);
        assert (files.length > 0) : "No checkpoint targets.";
        String nnHttpAddr = this.backupNode.nnHttpAddress;
        TransferFsImage.getFileClient(nnHttpAddr, fileid, files);
        LOG.info((Object)("Downloaded file " + files[0].getName() + " size " + files[0].length() + " bytes."));
        fileid = "getedit=1";
        list = this.getFSImage().getFiles(FSImage.NameNodeFile.EDITS, FSImage.NameNodeDirType.EDITS);
        files = list.toArray(new File[list.size()]);
        assert (files.length > 0) : "No checkpoint targets.";
        TransferFsImage.getFileClient(nnHttpAddr, fileid, files);
        LOG.info((Object)("Downloaded file " + files[0].getName() + " size " + files[0].length() + " bytes."));
    }

    private void uploadCheckpoint(CheckpointSignature sig) throws IOException {
        InetSocketAddress httpSocAddr = this.backupNode.getHttpAddress();
        int httpPort = httpSocAddr.getPort();
        String fileid = "putimage=1&port=" + httpPort + "&machine=" + InetAddress.getLocalHost().getHostAddress() + "&token=" + sig.toString();
        LOG.info((Object)("Posted URL " + this.backupNode.nnHttpAddress + fileid));
        TransferFsImage.getFileClient(this.backupNode.nnHttpAddress, fileid, null);
    }

    void doCheckpoint() throws IOException {
        long startTime = FSNamesystem.now();
        NamenodeCommand cmd = this.getNamenode().startCheckpoint(this.backupNode.getRegistration());
        CheckpointCommand cpCmd = null;
        switch (cmd.getAction()) {
            case 50: {
                this.shutdown();
                throw new IOException("Name-node " + this.backupNode.nnRpcAddress + " requested shutdown.");
            }
            case 51: {
                cpCmd = (CheckpointCommand)cmd;
                break;
            }
            default: {
                throw new IOException("Unsupported NamenodeCommand: " + cmd.getAction());
            }
        }
        CheckpointSignature sig = cpCmd.getSignature();
        assert (-24 == sig.getLayoutVersion()) : "Signature should have current layout version. Expected: -24 actual " + sig.getLayoutVersion();
        assert (!this.backupNode.isRole(HdfsConstants.NamenodeRole.CHECKPOINT) || cpCmd.isImageObsolete()) : "checkpoint node should always download image.";
        this.backupNode.setCheckpointState(FSImage.CheckpointStates.UPLOAD_START);
        if (cpCmd.isImageObsolete()) {
            this.backupNode.resetNamespace();
            this.downloadCheckpoint(sig);
        }
        BackupStorage bnImage = this.getFSImage();
        bnImage.loadCheckpoint(sig);
        sig.validateStorageInfo(bnImage);
        bnImage.saveCheckpoint();
        if (cpCmd.needToReturnImage()) {
            this.uploadCheckpoint(sig);
        }
        this.getNamenode().endCheckpoint(this.backupNode.getRegistration(), sig);
        bnImage.convergeJournalSpool();
        this.backupNode.setRegistration();
        if (this.backupNode.isRole(HdfsConstants.NamenodeRole.CHECKPOINT)) {
            this.getFSImage().getEditLog().close();
        }
        LOG.info((Object)("Checkpoint completed in " + (FSNamesystem.now() - startTime) / 1000L + " seconds." + " New Image Size: " + bnImage.getFsImageName().length()));
    }
}

