/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CheckpointCommand
extends NamenodeCommand {
    private CheckpointSignature cSig;
    private boolean isImageObsolete;
    private boolean needToReturnImage;
    public static final String __PARANAMER_DATA = "<init> org.apache.hadoop.hdfs.server.namenode.CheckpointSignature,boolean,boolean sig,isImgObsolete,needToReturnImg \nreadFields java.io.DataInput in \nwrite java.io.DataOutput out \n";

    public CheckpointCommand() {
        this(null, false, false);
    }

    public CheckpointCommand(CheckpointSignature sig, boolean isImgObsolete, boolean needToReturnImg) {
        super(51);
        this.cSig = sig;
        this.isImageObsolete = isImgObsolete;
        this.needToReturnImage = needToReturnImg;
    }

    public CheckpointSignature getSignature() {
        return this.cSig;
    }

    public boolean isImageObsolete() {
        return this.isImageObsolete;
    }

    public boolean needToReturnImage() {
        return this.needToReturnImage;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.cSig.write(out);
        out.writeBoolean(this.isImageObsolete);
        out.writeBoolean(this.needToReturnImage);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.cSig = new CheckpointSignature();
        this.cSig.readFields(in);
        this.isImageObsolete = in.readBoolean();
        this.needToReturnImage = in.readBoolean();
    }

    static {
        WritableFactories.setFactory(CheckpointCommand.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new CheckpointCommand();
            }
        });
    }
}

