/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.client;

import okuyama.imdst.client.OkuyamaClient;
import okuyama.imdst.client.OkuyamaClientException;

public class OkuyamaQueueClient
extends OkuyamaClient {
    public static String QUEUE_NAME_PREFIX = "Okuyama_Queue_Space_Name_Prefix_";
    public static String QUEUE_NAME_PREFIX_NOW_INDEX = "_Now_Index_";
    public static String QUEUE_NAME_PREFIX_NOW_POINT = "_Now_Point_";
    public static String QUEUE_TAKE_END_VALUE = "{OKUYAMA_QUEUE_END_DATA_MARKER}";

    public boolean createQueueSpace(String queueName) throws OkuyamaClientException {
        boolean ret = true;
        try {
            String[] setValueRet = super.setNewValue(QUEUE_NAME_PREFIX + QUEUE_NAME_PREFIX_NOW_INDEX + queueName, "0");
            if (!setValueRet[0].equals("true")) {
                return false;
            }
            setValueRet = super.setNewValue(QUEUE_NAME_PREFIX + QUEUE_NAME_PREFIX_NOW_POINT + queueName, "1");
            if (!setValueRet[0].equals("true")) {
                return false;
            }
        }
        catch (OkuyamaClientException oce) {
            throw oce;
        }
        catch (Exception e) {
            throw new OkuyamaClientException(e);
        }
        return ret;
    }

    public boolean removeQueueSpace(String queueName) throws OkuyamaClientException {
        boolean ret = true;
        try {
            String[] removeDataRet;
            String[] removeIndexRet = super.removeValue(QUEUE_NAME_PREFIX + QUEUE_NAME_PREFIX_NOW_INDEX + queueName);
            if (!removeIndexRet[0].equals("true")) {
                return false;
            }
            long idx = 1L;
            while ((removeDataRet = super.removeValue(QUEUE_NAME_PREFIX + QUEUE_NAME_PREFIX_NOW_POINT + queueName + "_" + idx + "_value"))[0].equals("true")) {
                ++idx;
            }
        }
        catch (OkuyamaClientException oce) {
            throw oce;
        }
        catch (Exception e) {
            throw new OkuyamaClientException(e);
        }
        return ret;
    }

    public boolean put(String queueName, String data) throws OkuyamaClientException {
        boolean ret = false;
        try {
            Object[] incrRet = super.incrValue(QUEUE_NAME_PREFIX + QUEUE_NAME_PREFIX_NOW_INDEX + queueName, 1L);
            if (incrRet[0].equals(new Boolean(true))) {
                String[] checkValue;
                if ((Long)incrRet[1] > 0L && (checkValue = super.getValue(QUEUE_NAME_PREFIX + QUEUE_NAME_PREFIX_NOW_POINT + queueName + "_" + ((Long)incrRet[1] - 1L) + "_value"))[0].equals("false")) {
                    super.setNewValue(QUEUE_NAME_PREFIX + QUEUE_NAME_PREFIX_NOW_POINT + queueName + "_" + ((Long)incrRet[1] - 1L) + "_value", QUEUE_TAKE_END_VALUE);
                }
                if (!(ret = super.setValue(QUEUE_NAME_PREFIX + QUEUE_NAME_PREFIX_NOW_POINT + queueName + "_" + (Long)incrRet[1] + "_value", data))) {
                    throw new OkuyamaClientException("Queue Data Put Error");
                }
            } else {
                ret = false;
            }
        }
        catch (OkuyamaClientException oce) {
            throw oce;
        }
        catch (Exception e) {
            throw new OkuyamaClientException(e);
        }
        return ret;
    }

    public String take(String queueName) throws OkuyamaClientException {
        return this.take(queueName, 30000L);
    }

    public String take(String queueName, long timeOut) throws OkuyamaClientException {
        String ret = null;
        boolean loopFlg = true;
        long startTime = System.currentTimeMillis();
        long endTime = startTime + timeOut;
        int maxContinueCount = 6;
        int nowContinueCount = 0;
        try {
            while (loopFlg) {
                String[] takeQueuePoint = super.getValue(QUEUE_NAME_PREFIX + QUEUE_NAME_PREFIX_NOW_POINT + queueName);
                if (!takeQueuePoint[0].equals("true")) {
                    return null;
                }
                Long queuePoint = new Long(takeQueuePoint[1]);
                String[] queueValueRet = super.getValueVersionCheck(QUEUE_NAME_PREFIX + QUEUE_NAME_PREFIX_NOW_POINT + queueName + "_" + queuePoint + "_value");
                if (queueValueRet[0].equals("true")) {
                    if (queueValueRet[1].equals(QUEUE_TAKE_END_VALUE)) {
                        if (nowContinueCount > maxContinueCount) {
                            Long recoverPointLong;
                            String[] recoverPointRet = super.getValueVersionCheck(QUEUE_NAME_PREFIX + QUEUE_NAME_PREFIX_NOW_POINT + queueName);
                            if (recoverPointRet[0].equals("true") && (recoverPointLong = new Long(recoverPointRet[1])).equals(queuePoint)) {
                                long recoverNowPoint = recoverPointLong;
                                super.setValueVersionCheck(QUEUE_NAME_PREFIX + QUEUE_NAME_PREFIX_NOW_POINT + queueName, new Long(++recoverNowPoint).toString(), recoverPointRet[2]);
                            }
                            nowContinueCount = 0;
                        }
                        if (System.currentTimeMillis() > endTime) {
                            return null;
                        }
                        Thread.sleep(15L);
                        ++nowContinueCount;
                        continue;
                    }
                    String[] checkUpdateRet = super.setValueVersionCheck(QUEUE_NAME_PREFIX + QUEUE_NAME_PREFIX_NOW_POINT + queueName + "_" + queuePoint + "_value", QUEUE_TAKE_END_VALUE, queueValueRet[2]);
                    if (checkUpdateRet[0].equals("true")) {
                        String[] checkNowQueuePoint = super.getValueVersionCheck(QUEUE_NAME_PREFIX + QUEUE_NAME_PREFIX_NOW_POINT + queueName);
                        if (checkNowQueuePoint[0].equals("true")) {
                            long checkNowQueuePointLong = new Long(checkNowQueuePoint[1]);
                            if (queuePoint == checkNowQueuePointLong) {
                                String[] queueTakePointUpdateRet = super.setValueVersionCheck(QUEUE_NAME_PREFIX + QUEUE_NAME_PREFIX_NOW_POINT + queueName, new Long(++checkNowQueuePointLong).toString(), checkNowQueuePoint[2]);
                            }
                        } else {
                            throw new OkuyamaClientException("Queue Take Point Update Error");
                        }
                        ret = queueValueRet[1];
                        loopFlg = false;
                        continue;
                    }
                    if (System.currentTimeMillis() > endTime) {
                        return null;
                    }
                    Thread.sleep(15L);
                    continue;
                }
                if (System.currentTimeMillis() > endTime) {
                    return null;
                }
                Thread.sleep(15L);
            }
        }
        catch (OkuyamaClientException oce) {
            throw oce;
        }
        catch (Exception e) {
            throw new OkuyamaClientException(e);
        }
        return ret;
    }
}

