/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import com.sun.security.auth.NTUserPrincipal;
import com.sun.security.auth.UnixPrincipal;
import com.sun.security.auth.module.Krb5LoginModule;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.TokenStorage;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class UserGroupInformation {
    private static final Log LOG = LogFactory.getLog(UserGroupInformation.class);
    private static boolean isInitialized = false;
    private static boolean useKerberos;
    private static Groups groups;
    private static long lastUnsuccessfulAuthenticationAttemptTime;
    public static final long MIN_TIME_BEFORE_RELOGIN = 600000L;
    public static final String HADOOP_TOKEN_FILE_LOCATION = "HADOOP_TOKEN_FILE_LOCATION";
    private static UserGroupInformation loginUser;
    private static String keytabPrincipal;
    private static String keytabFile;
    private final Subject subject;
    private static LoginContext login;
    private static final String OS_LOGIN_MODULE_NAME;
    private static final Class<? extends Principal> OS_PRINCIPAL_CLASS;
    private static final boolean windows;

    private static synchronized void ensureInitialized() {
        if (!isInitialized) {
            UserGroupInformation.initialize(new Configuration());
        }
    }

    private static synchronized void initialize(Configuration conf) {
        String value = conf.get("hadoop.security.authentication");
        if (value == null || "simple".equals(value)) {
            useKerberos = false;
        } else if ("kerberos".equals(value)) {
            useKerberos = true;
        } else {
            throw new IllegalArgumentException("Invalid attribute value for hadoop.security.authentication of " + value);
        }
        if (!(groups instanceof TestingGroups)) {
            groups = Groups.getUserToGroupsMappingService(conf);
        }
        javax.security.auth.login.Configuration.setConfiguration(new HadoopConfiguration());
        isInitialized = true;
    }

    public static void setConfiguration(Configuration conf) {
        UserGroupInformation.initialize(conf);
    }

    public static boolean isSecurityEnabled() {
        UserGroupInformation.ensureInitialized();
        return useKerberos;
    }

    UserGroupInformation(Subject subject) {
        this.subject = subject;
    }

    public static UserGroupInformation getCurrentUser() throws IOException {
        AccessControlContext context = AccessController.getContext();
        Subject subject = Subject.getSubject(context);
        return subject == null ? UserGroupInformation.getLoginUser() : new UserGroupInformation(subject);
    }

    public static synchronized UserGroupInformation getLoginUser() throws IOException {
        if (loginUser == null) {
            try {
                login = UserGroupInformation.isSecurityEnabled() ? new LoginContext("hadoop-user-kerberos") : new LoginContext("hadoop-simple");
                login.login();
                loginUser = new UserGroupInformation(login.getSubject());
                String tokenFile = System.getenv(HADOOP_TOKEN_FILE_LOCATION);
                if (tokenFile != null && UserGroupInformation.isSecurityEnabled()) {
                    TokenStorage.readTokensAndLoadInUGI(tokenFile, new Configuration(), loginUser);
                }
            }
            catch (LoginException le) {
                throw new IOException("failure to login", le);
            }
        }
        return loginUser;
    }

    public static synchronized void loginUserFromKeytab(String user, String path) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        keytabFile = path;
        keytabPrincipal = user;
        try {
            login = new LoginContext("hadoop-keytab-kerberos");
            login.login();
            loginUser = new UserGroupInformation(login.getSubject());
        }
        catch (LoginException le) {
            throw new IOException("Login failure for " + user + " from keytab " + path, le);
        }
    }

    public synchronized void reloginFromKeytab() throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        if (login == null || keytabFile == null) {
            throw new IOException("loginUserFromKeyTab must be done first");
        }
        if (System.currentTimeMillis() - lastUnsuccessfulAuthenticationAttemptTime < 600000L) {
            LOG.warn((Object)"Not attempting to re-login since the last re-login was attempted less than 600 seconds before.");
            return;
        }
        try {
            LOG.info((Object)("Initiating logout for " + this.getUserName()));
            login.logout();
            login = new LoginContext("hadoop-keytab-kerberos", this.getSubject());
            LOG.info((Object)("Initiating re-login for " + keytabPrincipal));
            login.login();
        }
        catch (LoginException le) {
            throw new IOException("Login failure for " + keytabPrincipal + " from keytab " + keytabFile, le);
        }
    }

    public static synchronized void setLastUnsuccessfulAuthenticationAttemptTime(long time) {
        lastUnsuccessfulAuthenticationAttemptTime = time;
    }

    public static synchronized boolean isLoginKeytabBased() {
        return keytabFile != null;
    }

    public static UserGroupInformation createRemoteUser(String user) {
        if (user == null || "".equals(user)) {
            throw new IllegalArgumentException("Null user");
        }
        Subject subject = new Subject();
        subject.getPrincipals().add(new User(user));
        return new UserGroupInformation(subject);
    }

    public static UserGroupInformation createProxyUser(String user, UserGroupInformation realUser) {
        if (user == null || "".equals(user)) {
            throw new IllegalArgumentException("Null user");
        }
        if (realUser == null) {
            throw new IllegalArgumentException("Null real user");
        }
        Subject subject = new Subject();
        subject.getPrincipals().add(new User(user));
        subject.getPrincipals().add(new RealUser(realUser));
        return new UserGroupInformation(subject);
    }

    public UserGroupInformation getRealUser() {
        Iterator<RealUser> i$ = this.subject.getPrincipals(RealUser.class).iterator();
        if (i$.hasNext()) {
            RealUser p = i$.next();
            return p.getRealUser();
        }
        return null;
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    public static UserGroupInformation createUserForTesting(String user, String[] userGroups) {
        UserGroupInformation.ensureInitialized();
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser(user);
        if (!(groups instanceof TestingGroups)) {
            groups = new TestingGroups();
        }
        ((TestingGroups)UserGroupInformation.groups).setUserGroups(ugi.getShortUserName(), userGroups);
        return ugi;
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    public static UserGroupInformation createProxyUserForTesting(String user, UserGroupInformation realUser, String[] userGroups) {
        UserGroupInformation.ensureInitialized();
        UserGroupInformation ugi = UserGroupInformation.createProxyUser(user, realUser);
        if (!(groups instanceof TestingGroups)) {
            groups = new TestingGroups();
        }
        ((TestingGroups)UserGroupInformation.groups).setUserGroups(ugi.getShortUserName(), userGroups);
        return ugi;
    }

    public String getShortUserName() {
        Iterator<User> i$ = this.subject.getPrincipals(User.class).iterator();
        if (i$.hasNext()) {
            User p = i$.next();
            return p.getShortName();
        }
        return null;
    }

    public String getUserName() {
        Iterator<User> i$ = this.subject.getPrincipals(User.class).iterator();
        if (i$.hasNext()) {
            User p = i$.next();
            return p.getName();
        }
        return null;
    }

    public synchronized boolean addToken(Token<? extends TokenIdentifier> token) {
        return this.subject.getPrivateCredentials().add(token);
    }

    public synchronized Collection<Token<? extends TokenIdentifier>> getTokens() {
        Set<Object> creds = this.subject.getPrivateCredentials();
        ArrayList<Token> result = new ArrayList<Token>(creds.size());
        for (Object o : creds) {
            if (!(o instanceof Token)) continue;
            result.add((Token)o);
        }
        return Collections.unmodifiableList(result);
    }

    public synchronized String[] getGroupNames() {
        UserGroupInformation.ensureInitialized();
        try {
            List<String> result = groups.getGroups(this.getShortUserName());
            return result.toArray(new String[result.size()]);
        }
        catch (IOException ie) {
            LOG.warn((Object)("No groups available for user " + this.getShortUserName()));
            return new String[0];
        }
    }

    public String toString() {
        if (this.getRealUser() != null) {
            return this.getUserName() + " via " + this.getRealUser().toString();
        }
        return this.getUserName();
    }

    public synchronized void setAuthenticationMethod(AuthenticationMethod authMethod) {
        for (User p : this.subject.getPrincipals(User.class)) {
            p.setAuthenticationMethod(authMethod);
        }
    }

    public synchronized AuthenticationMethod getAuthenticationMethod() {
        Iterator<User> i$ = this.subject.getPrincipals(User.class).iterator();
        if (i$.hasNext()) {
            User p = i$.next();
            return p.getAuthenticationMethod();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.subject.equals(((UserGroupInformation)o).subject);
    }

    public int hashCode() {
        return this.subject.hashCode();
    }

    protected Subject getSubject() {
        return this.subject;
    }

    public <T> T doAs(PrivilegedAction<T> action) {
        return Subject.doAs(this.subject, action);
    }

    public <T> T doAs(PrivilegedExceptionAction<T> action) throws IOException, InterruptedException {
        try {
            return Subject.doAs(this.subject, action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            throw new UndeclaredThrowableException(pae, "Unknown exception in doAs");
        }
    }

    private void print() throws IOException {
        System.out.println("User: " + this.getUserName());
        System.out.print("Group Ids: ");
        System.out.println();
        String[] groups = this.getGroupNames();
        System.out.print("Groups: ");
        for (int i = 0; i < groups.length; ++i) {
            System.out.print(groups[i] + " ");
        }
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Getting UGI for current user");
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        ugi.print();
        System.out.println("UGI: " + ugi);
        System.out.println("============================================================");
        if (args.length == 2) {
            System.out.println("Getting UGI from keytab....");
            UserGroupInformation.loginUserFromKeytab(args[0], args[1]);
            UserGroupInformation.getCurrentUser().print();
            System.out.println("Keytab: " + ugi);
        }
    }

    static /* synthetic */ String access$400() {
        return OS_LOGIN_MODULE_NAME;
    }

    static {
        loginUser = null;
        keytabPrincipal = null;
        keytabFile = null;
        windows = System.getProperty("os.name").startsWith("Windows");
        if (windows) {
            OS_LOGIN_MODULE_NAME = "com.sun.security.auth.module.NTLoginModule";
            OS_PRINCIPAL_CLASS = NTUserPrincipal.class;
        } else {
            OS_LOGIN_MODULE_NAME = "com.sun.security.auth.module.UnixLoginModule";
            OS_PRINCIPAL_CLASS = UnixPrincipal.class;
        }
    }

    private static class TestingGroups
    extends Groups {
        private final Map<String, List<String>> userToGroupsMapping = new HashMap<String, List<String>>();

        private TestingGroups() {
            super(new Configuration());
        }

        @Override
        public List<String> getGroups(String user) {
            List<String> result = this.userToGroupsMapping.get(user);
            if (result == null) {
                result = new ArrayList<String>();
            }
            return result;
        }

        private void setUserGroups(String user, String[] groups) {
            this.userToGroupsMapping.put(user, Arrays.asList(groups));
        }
    }

    @InterfaceStability.Evolving
    public static enum AuthenticationMethod {
        SIMPLE,
        KERBEROS,
        TOKEN,
        CERTIFICATE,
        KERBEROS_SSL,
        PROXY;

    }

    private static class HadoopConfiguration
    extends javax.security.auth.login.Configuration {
        private static final String SIMPLE_CONFIG_NAME = "hadoop-simple";
        private static final String USER_KERBEROS_CONFIG_NAME = "hadoop-user-kerberos";
        private static final String KEYTAB_KERBEROS_CONFIG_NAME = "hadoop-keytab-kerberos";
        private static final AppConfigurationEntry OS_SPECIFIC_LOGIN = new AppConfigurationEntry(UserGroupInformation.access$400(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new HashMap());
        private static final AppConfigurationEntry HADOOP_LOGIN = new AppConfigurationEntry(HadoopLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new HashMap());
        private static final Map<String, String> USER_KERBEROS_OPTIONS = new HashMap<String, String>();
        private static final AppConfigurationEntry USER_KERBEROS_LOGIN;
        private static final Map<String, String> KEYTAB_KERBEROS_OPTIONS;
        private static final AppConfigurationEntry KEYTAB_KERBEROS_LOGIN;
        private static final AppConfigurationEntry[] SIMPLE_CONF;
        private static final AppConfigurationEntry[] USER_KERBEROS_CONF;
        private static final AppConfigurationEntry[] KEYTAB_KERBEROS_CONF;

        private HadoopConfiguration() {
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            if (SIMPLE_CONFIG_NAME.equals(appName)) {
                return SIMPLE_CONF;
            }
            if (USER_KERBEROS_CONFIG_NAME.equals(appName)) {
                return USER_KERBEROS_CONF;
            }
            if (KEYTAB_KERBEROS_CONFIG_NAME.equals(appName)) {
                KEYTAB_KERBEROS_OPTIONS.put("keyTab", keytabFile);
                KEYTAB_KERBEROS_OPTIONS.put("principal", keytabPrincipal);
                return KEYTAB_KERBEROS_CONF;
            }
            return null;
        }

        static {
            USER_KERBEROS_OPTIONS.put("doNotPrompt", "true");
            USER_KERBEROS_OPTIONS.put("useTicketCache", "true");
            USER_KERBEROS_OPTIONS.put("renewTGT", "true");
            String ticketCache = System.getenv("KRB5CCNAME");
            if (ticketCache != null) {
                USER_KERBEROS_OPTIONS.put("ticketCache", ticketCache);
            }
            USER_KERBEROS_LOGIN = new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, USER_KERBEROS_OPTIONS);
            KEYTAB_KERBEROS_OPTIONS = new HashMap<String, String>();
            KEYTAB_KERBEROS_OPTIONS.put("doNotPrompt", "true");
            KEYTAB_KERBEROS_OPTIONS.put("useKeyTab", "true");
            KEYTAB_KERBEROS_OPTIONS.put("storeKey", "true");
            KEYTAB_KERBEROS_LOGIN = new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, KEYTAB_KERBEROS_OPTIONS);
            SIMPLE_CONF = new AppConfigurationEntry[]{OS_SPECIFIC_LOGIN, HADOOP_LOGIN};
            USER_KERBEROS_CONF = new AppConfigurationEntry[]{OS_SPECIFIC_LOGIN, USER_KERBEROS_LOGIN, HADOOP_LOGIN};
            KEYTAB_KERBEROS_CONF = new AppConfigurationEntry[]{KEYTAB_KERBEROS_LOGIN, HADOOP_LOGIN};
        }
    }

    private static class RealUser
    implements Principal {
        private final UserGroupInformation realUser;

        RealUser(UserGroupInformation realUser) {
            this.realUser = realUser;
        }

        @Override
        public String getName() {
            return this.realUser.getUserName();
        }

        public UserGroupInformation getRealUser() {
            return this.realUser;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.realUser.equals(((RealUser)o).realUser);
        }

        @Override
        public int hashCode() {
            return this.realUser.hashCode();
        }

        @Override
        public String toString() {
            return this.realUser.toString();
        }
    }

    @InterfaceAudience.Private
    public static class HadoopLoginModule
    implements LoginModule {
        private Subject subject;

        @Override
        public boolean abort() throws LoginException {
            return true;
        }

        private <T extends Principal> T getCanonicalUser(Class<T> cls) {
            Iterator<T> i$ = this.subject.getPrincipals(cls).iterator();
            if (i$.hasNext()) {
                Principal user = (Principal)i$.next();
                return (T)user;
            }
            return null;
        }

        @Override
        public boolean commit() throws LoginException {
            KerberosPrincipal user = null;
            if (useKerberos) {
                user = this.getCanonicalUser(KerberosPrincipal.class);
            }
            if (user == null) {
                user = this.getCanonicalUser(OS_PRINCIPAL_CLASS);
            }
            if (user != null) {
                this.subject.getPrincipals().add(new User(user.getName()));
                return true;
            }
            LOG.error((Object)("Can't find user in " + this.subject));
            throw new LoginException("Can't find user name");
        }

        @Override
        public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
            this.subject = subject;
        }

        @Override
        public boolean login() throws LoginException {
            return true;
        }

        @Override
        public boolean logout() throws LoginException {
            return true;
        }
    }
}

