/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Queue;
import org.apache.hadoop.mapred.QueueConfigurationParser;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapreduce.QueueState;
import org.apache.hadoop.security.authorize.AccessControlList;

class DeprecatedQueueConfigurationParser
extends QueueConfigurationParser {
    private static final Log LOG = LogFactory.getLog(DeprecatedQueueConfigurationParser.class);
    static final String MAPRED_QUEUE_NAMES_KEY = "mapred.queue.names";

    DeprecatedQueueConfigurationParser(Configuration conf) {
        if (!this.deprecatedConf(conf)) {
            return;
        }
        List<Queue> listq = this.createQueues(conf);
        this.setAclsEnabled(conf.getBoolean("mapred.acls.enabled", false));
        this.root = new Queue();
        this.root.setName("");
        for (Queue q : listq) {
            this.root.addChild(q);
        }
    }

    private List<Queue> createQueues(Configuration conf) {
        String[] queueNameValues = conf.getStrings(MAPRED_QUEUE_NAMES_KEY);
        ArrayList<Queue> list = new ArrayList<Queue>();
        for (String name : queueNameValues) {
            try {
                Map<String, AccessControlList> acls = this.getQueueAcls(name, conf);
                QueueState state = this.getQueueState(name, conf);
                Queue q = new Queue(name, acls, state);
                list.add(q);
            }
            catch (Throwable t) {
                LOG.warn((Object)("Not able to initialize queue " + name));
            }
        }
        return list;
    }

    private QueueState getQueueState(String name, Configuration conf) {
        String stateVal = conf.get(QueueManager.toFullPropertyName(name, "state"), QueueState.RUNNING.getStateName());
        return QueueState.getState(stateVal);
    }

    private boolean deprecatedConf(Configuration conf) {
        String[] queues = null;
        String queueNameValues = this.getQueueNames(conf);
        if (queueNameValues == null) {
            return false;
        }
        LOG.warn((Object)"Configuring \"mapred.queue.names\" in mapred-site.xml or hadoop-site.xml is deprecated and will overshadow mapred-queues.xml. Remove this property and configure queue hierarchy in mapred-queues.xml");
        queues = conf.getStrings(MAPRED_QUEUE_NAMES_KEY);
        String aclsEnable = conf.get("mapred.acls.enabled");
        if (aclsEnable != null) {
            LOG.warn((Object)"Configuring \"mapred.acls.enabled\" in mapred-site.xml or hadoop-site.xml is deprecated. Configure queue hierarchy in mapred-queues.xml");
        }
        if (queues != null) {
            for (String queue : queues) {
                for (Queue.QueueOperation oper : Queue.QueueOperation.values()) {
                    String key = QueueManager.toFullPropertyName(queue, oper.getAclName());
                    String aclString = conf.get(key);
                    if (aclString == null) continue;
                    LOG.warn((Object)"Configuring queue ACLs in mapred-site.xml or hadoop-site.xml is deprecated. Configure queue ACLs in mapred-queues.xml");
                    return true;
                }
            }
        }
        return true;
    }

    private String getQueueNames(Configuration conf) {
        String queueNameValues = conf.get(MAPRED_QUEUE_NAMES_KEY);
        return queueNameValues;
    }

    private Map<String, AccessControlList> getQueueAcls(String name, Configuration conf) {
        HashMap<String, AccessControlList> map = new HashMap<String, AccessControlList>();
        for (Queue.QueueOperation oper : Queue.QueueOperation.values()) {
            String aclKey = QueueManager.toFullPropertyName(name, oper.getAclName());
            map.put(aclKey, new AccessControlList(conf.get(aclKey, "*")));
        }
        return map;
    }
}

