/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.mapred.StatisticsCollector;

class JobTrackerStatistics {
    final StatisticsCollector collector;
    final Map<String, TaskTrackerStat> ttStats = new HashMap<String, TaskTrackerStat>();

    JobTrackerStatistics() {
        this.collector = new StatisticsCollector();
        this.collector.start();
    }

    synchronized void taskTrackerAdded(String name) {
        TaskTrackerStat stat = this.ttStats.get(name);
        if (stat == null) {
            stat = new TaskTrackerStat(name);
            this.ttStats.put(name, stat);
        }
    }

    synchronized void taskTrackerRemoved(String name) {
        TaskTrackerStat stat = this.ttStats.remove(name);
        if (stat != null) {
            stat.remove();
        }
    }

    synchronized TaskTrackerStat getTaskTrackerStat(String name) {
        return this.ttStats.get(name);
    }

    class TaskTrackerStat {
        final String totalTasksKey;
        final StatisticsCollector.Stat totalTasksStat;
        final String succeededTasksKey;
        final StatisticsCollector.Stat succeededTasksStat;
        final String healthCheckFailedKey;
        final StatisticsCollector.Stat healthCheckFailedStat;

        TaskTrackerStat(String trackerName) {
            this.totalTasksKey = trackerName + "-" + "totalTasks";
            this.totalTasksStat = JobTrackerStatistics.this.collector.createStat(this.totalTasksKey);
            this.succeededTasksKey = trackerName + "-" + "succeededTasks";
            this.succeededTasksStat = JobTrackerStatistics.this.collector.createStat(this.succeededTasksKey);
            this.healthCheckFailedKey = trackerName + "-" + "healthcheckfailed";
            this.healthCheckFailedStat = JobTrackerStatistics.this.collector.createStat(this.healthCheckFailedKey);
        }

        synchronized void incrTotalTasks() {
            this.totalTasksStat.inc();
        }

        synchronized void incrSucceededTasks() {
            this.succeededTasksStat.inc();
        }

        synchronized void incrHealthCheckFailed() {
            this.healthCheckFailedStat.inc();
        }

        synchronized void remove() {
            JobTrackerStatistics.this.collector.removeStat(this.totalTasksKey);
            JobTrackerStatistics.this.collector.removeStat(this.succeededTasksKey);
            JobTrackerStatistics.this.collector.removeStat(this.healthCheckFailedKey);
        }
    }
}

