/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.JobTrackerStatistics;
import org.apache.hadoop.mapred.StatisticsCollector;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;

public final class machines_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static final long serialVersionUID = 1L;
    private static List _jspx_dependants;

    public void generateTaskTrackerTable(JspWriter out, String type, JobTracker tracker) throws IOException {
        Collection<TaskTrackerStatus> c;
        if ("blacklisted".equals(type)) {
            out.println("<h2>Blacklisted Task Trackers</h2>");
            c = tracker.blacklistedTaskTrackers();
        } else if ("active".equals(type)) {
            out.println("<h2>Active Task Trackers</h2>");
            c = tracker.activeTaskTrackers();
        } else {
            out.println("<h2>Task Trackers</h2>");
            c = tracker.taskTrackers();
        }
        StatisticsCollector cfr_ignored_0 = tracker.getStatistics().collector;
        int noCols = 9 + 3 * StatisticsCollector.DEFAULT_COLLECT_WINDOWS.length;
        if (type.equals("blacklisted")) {
            ++noCols;
        }
        if (c.size() == 0) {
            out.print("There are currently no known " + type + " Task Trackers.");
        } else {
            out.print("<center>\n");
            out.print("<table border=\"2\" cellpadding=\"5\" cellspacing=\"2\">\n");
            out.print("<tr><td align=\"center\" colspan=\"" + noCols + "\"><b>Task Trackers</b></td></tr>\n");
            out.print("<tr><td><b>Name</b></td><td><b>Host</b></td><td><b># running tasks</b></td><td><b>Max Map Tasks</b></td><td><b>Max Reduce Tasks</b></td><td><b>Failures</b></td><td><b>Node Health Status</b></td><td><b>Seconds Since Node Last Healthy</b></td>");
            if (type.equals("blacklisted")) {
                out.print("<td><b>Reason For blacklisting</b></td>");
            }
            StatisticsCollector cfr_ignored_1 = tracker.getStatistics().collector;
            for (StatisticsCollector.TimeWindow window : StatisticsCollector.DEFAULT_COLLECT_WINDOWS) {
                out.println("<td><b>Total Tasks " + window.name + "</b></td>");
                out.println("<td><b>Succeeded Tasks " + window.name + "</b></td>");
                out.println("<td><b>Failed Health Checks " + window.name + "</b></td>");
            }
            out.print("<td><b>Seconds since heartbeat</b></td></tr>\n");
            int maxFailures = 0;
            String failureKing = null;
            for (TaskTrackerStatus tt : c) {
                long sinceHeartbeat = System.currentTimeMillis() - tt.getLastSeen();
                boolean isHealthy = tt.getHealthStatus().isNodeHealthy();
                long sinceHealthCheck = tt.getHealthStatus().getLastReported();
                String healthString = "";
                if (sinceHealthCheck == 0L) {
                    healthString = "N/A";
                } else {
                    healthString = isHealthy ? "Healthy" : "Unhealthy";
                    sinceHealthCheck = System.currentTimeMillis() - sinceHealthCheck;
                    sinceHealthCheck /= 1000L;
                }
                if (sinceHeartbeat > 0L) {
                    sinceHeartbeat /= 1000L;
                }
                int numCurTasks = 0;
                Iterator<TaskStatus> it2 = tt.getTaskReports().iterator();
                while (it2.hasNext()) {
                    it2.next();
                    ++numCurTasks;
                }
                int numFailures = tt.getFailures();
                if (numFailures > maxFailures) {
                    maxFailures = numFailures;
                    failureKing = tt.getTrackerName();
                }
                out.print("<tr><td><a href=\"http://");
                out.print(tt.getHost() + ":" + tt.getHttpPort() + "/\">");
                out.print(tt.getTrackerName() + "</a></td><td>");
                out.print(tt.getHost() + "</td><td>" + numCurTasks + "</td><td>" + tt.getMaxMapSlots() + "</td><td>" + tt.getMaxReduceSlots() + "</td><td>" + numFailures + "</td><td>" + healthString + "</td><td>" + sinceHealthCheck);
                if (type.equals("blacklisted")) {
                    out.print("</td><td>" + tracker.getFaultReport(tt.getHost()));
                }
                StatisticsCollector cfr_ignored_2 = tracker.getStatistics().collector;
                for (StatisticsCollector.TimeWindow window : StatisticsCollector.DEFAULT_COLLECT_WINDOWS) {
                    JobTrackerStatistics.TaskTrackerStat ttStat = tracker.getStatistics().getTaskTrackerStat(tt.getTrackerName());
                    out.println("</td><td>" + ttStat.totalTasksStat.getValues().get(window).getValue());
                    out.println("</td><td>" + ttStat.succeededTasksStat.getValues().get(window).getValue());
                    out.println("</td><td>" + ttStat.healthCheckFailedStat.getValues().get(window).getValue());
                }
                out.print("</td><td>" + sinceHeartbeat + "</td></tr>\n");
            }
            out.print("</table>\n");
            out.print("</center>\n");
            if (maxFailures > 0) {
                out.print("Highest Failures: " + failureKing + " with " + maxFailures + " failures<br>\n");
            }
        }
    }

    public void generateTableForExcludedNodes(JspWriter out, JobTracker tracker) throws IOException {
        out.println("<h2>Excluded Nodes</h2>");
        Collection<String> d = tracker.getExcludedNodes();
        if (d.size() == 0) {
            out.print("There are currently no excluded hosts.");
        } else {
            out.print("<center>\n");
            out.print("<table border=\"2\" cellpadding=\"5\" cellspacing=\"2\">\n");
            out.print("<tr>");
            out.print("<td><b>Host Name</b></td></tr>\n");
            for (String dt : d) {
                out.print("<td>" + dt + "</td></tr>\n");
            }
            out.print("</table>\n");
            out.print("</center>\n");
        }
    }

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        JspFactory _jspxFactory = null;
        PageContext pageContext = null;
        HttpSession session = null;
        ServletContext application = null;
        ServletConfig config = null;
        JspWriter out = null;
        machines_jsp page = this;
        JspWriter _jspx_out = null;
        PageContext _jspx_page_context = null;
        try {
            _jspxFactory = JspFactory.getDefaultFactory();
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            out.write(10);
            out.write(10);
            out.write(10);
            JobTracker tracker = (JobTracker)application.getAttribute("job.tracker");
            String trackerName = StringUtils.simpleHostname((String)tracker.getJobTrackerMachine());
            String type = request.getParameter("type");
            out.write(10);
            out.write("\n\n<html>\n\n<title>");
            out.print(trackerName);
            out.write(" Hadoop Machine List</title>\n\n<body>\n<h1><a href=\"jobtracker.jsp\">");
            out.print(trackerName);
            out.write("</a> Hadoop Machine List</h1>\n\n");
            if ("excluded".equals(type)) {
                this.generateTableForExcludedNodes(out, tracker);
            } else {
                this.generateTaskTrackerTable(out, type, tracker);
            }
            out.write(10);
            out.write(10);
            out.println(ServletUtil.htmlFooter());
            out.write(10);
            if (_jspxFactory == null) return;
        }
        catch (Throwable t) {
            try {
                if (t instanceof SkipPageException) return;
                out = _jspx_out;
                if (out != null && out.getBufferSize() != 0) {
                    out.clearBuffer();
                }
                if (_jspx_page_context == null) return;
                _jspx_page_context.handlePageException(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (_jspxFactory != null) {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
        return;
    }
}

