/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.mapred.JSPUtil;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryViewer;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.util.StringUtils;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;

public final class taskdetailshistory_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("d/MM HH:mm:ss");
    private static final long serialVersionUID = 1L;
    private static List _jspx_dependants;

    private void printTaskAttempt(JobHistoryParser.TaskAttemptInfo taskAttempt, TaskType type, JspWriter out, String logFile) throws IOException {
        out.print("<tr>");
        out.print("<td>" + taskAttempt.getAttemptId() + "</td>");
        out.print("<td>" + StringUtils.getFormattedTimeWithDiff((DateFormat)dateFormat, (long)taskAttempt.getStartTime(), (long)0L) + "</td>");
        if (TaskType.REDUCE.equals((Object)type)) {
            out.print("<td>" + StringUtils.getFormattedTimeWithDiff((DateFormat)dateFormat, (long)taskAttempt.getShuffleFinishTime(), (long)taskAttempt.getStartTime()) + "</td>");
            out.print("<td>" + StringUtils.getFormattedTimeWithDiff((DateFormat)dateFormat, (long)taskAttempt.getSortFinishTime(), (long)taskAttempt.getShuffleFinishTime()) + "</td>");
        }
        out.print("<td>" + StringUtils.getFormattedTimeWithDiff((DateFormat)dateFormat, (long)taskAttempt.getFinishTime(), (long)taskAttempt.getStartTime()) + "</td>");
        out.print("<td>" + taskAttempt.getHostname() + "</td>");
        out.print("<td>" + HtmlQuoting.quoteHtmlChars((String)taskAttempt.getError()) + "</td>");
        out.print("<td>");
        String taskLogsUrl = HistoryViewer.getTaskLogsUrl(taskAttempt);
        if (taskLogsUrl != null) {
            String tailFourKBUrl = taskLogsUrl + "&start=-4097";
            String tailEightKBUrl = taskLogsUrl + "&start=-8193";
            String entireLogUrl = taskLogsUrl + "&all=true";
            out.print("<a href=\"" + tailFourKBUrl + "\">Last 4KB</a><br/>");
            out.print("<a href=\"" + tailEightKBUrl + "\">Last 8KB</a><br/>");
            out.print("<a href=\"" + entireLogUrl + "\">All</a><br/>");
        } else {
            out.print("n/a");
        }
        out.print("</td>");
        Counters counters = taskAttempt.getCounters();
        if (counters != null) {
            TaskAttemptID attemptId = taskAttempt.getAttemptId();
            out.print("<td><a href=\"/taskstatshistory.jsp?attemptid=" + attemptId + "&logFile=" + logFile + "\">" + counters.countCounters() + "</a></td>");
        } else {
            out.print("<td></td>");
        }
        out.print("</tr>");
    }

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        JobHistoryParser.JobInfo job;
        String tipid;
        String logFile;
        PageContext _jspx_page_context;
        JspWriter _jspx_out;
        JspWriter out;
        JspFactory _jspxFactory;
        block12: {
            _jspxFactory = null;
            PageContext pageContext = null;
            HttpSession session = null;
            ServletContext application = null;
            ServletConfig config = null;
            out = null;
            taskdetailshistory_jsp page = this;
            _jspx_out = null;
            _jspx_page_context = null;
            _jspxFactory = JspFactory.getDefaultFactory();
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            out.write(10);
            out.write(10);
            out.write(10);
            out.write(10);
            out.write(10);
            out.write(10);
            logFile = request.getParameter("logFile");
            tipid = request.getParameter("tipid");
            FileSystem fs = (FileSystem)application.getAttribute("fileSys");
            JobTracker jobTracker = (JobTracker)application.getAttribute("job.tracker");
            job = JSPUtil.checkAccessAndGetJobInfo(request, response, jobTracker, fs, new Path(logFile));
            if (job != null) break block12;
            if (_jspxFactory == null) return;
            _jspxFactory.releasePageContext(_jspx_page_context);
            return;
        }
        try {
            JobHistoryParser.TaskInfo task = job.getAllTasks().get(TaskID.forName(tipid));
            TaskType type = task.getTaskType();
            out.write("\n<html>\n<body>\n<h2>");
            out.print(tipid);
            out.write(" attempts for <a href=\"jobdetailshistory.jsp?logFile=");
            out.print(logFile);
            out.write(34);
            out.write(62);
            out.write(32);
            out.print((Object)job.getJobId());
            out.write(" </a></h2>\n<center>\n<table border=\"2\" cellpadding=\"5\" cellspacing=\"2\">\n<tr><td>Task Id</td><td>Start Time</td>\n");
            if (TaskType.REDUCE.equals((Object)type)) {
                out.write("\n    <td>Shuffle Finished</td><td>Sort Finished</td>\n");
            }
            out.write("\n<td>Finish Time</td><td>Host</td><td>Error</td><td>Task Logs</td>\n<td>Counters</td></tr>\n\n");
            for (JobHistoryParser.TaskAttemptInfo attempt : task.getAllTaskAttempts().values()) {
                this.printTaskAttempt(attempt, type, out, logFile);
            }
            out.write("\n</table>\n</center>\n");
            if (TaskType.MAP.equals((Object)type)) {
                out.write("\n<h3>Input Split Locations</h3>\n<table border=\"2\" cellpadding=\"5\" cellspacing=\"2\">\n");
                for (String split : StringUtils.split((String)task.getSplitLocations())) {
                    out.println("<tr><td>" + split + "</td></tr>");
                }
                out.write("\n</table>    \n");
            }
            out.write(10);
            out.write("\n</body>\n</html>\n");
            if (_jspxFactory == null) return;
        }
        catch (Throwable t) {
            try {
                if (t instanceof SkipPageException) return;
                out = _jspx_out;
                if (out != null && out.getBufferSize() != 0) {
                    out.clearBuffer();
                }
                if (_jspx_page_context == null) return;
                _jspx_page_context.handlePageException(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (_jspxFactory != null) {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
        return;
    }
}

