/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.LocalJobRunner;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.QueueAclsInfo;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.jobhistory.JobHistory;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.server.jobtracker.State;
import org.apache.hadoop.mapreduce.util.ConfigUtil;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Cluster {
    private ClientProtocol client;
    private UserGroupInformation ugi;
    private Configuration conf;
    private FileSystem fs = null;
    private Path sysDir = null;
    private Path stagingAreaDir = null;
    private Path jobHistoryDir = null;

    public Cluster(Configuration conf) throws IOException {
        this.conf = conf;
        this.ugi = UserGroupInformation.getCurrentUser();
        this.client = this.createClient(conf);
    }

    public Cluster(InetSocketAddress jobTrackAddr, Configuration conf) throws IOException {
        this.conf = conf;
        this.ugi = UserGroupInformation.getCurrentUser();
        this.client = this.createRPCProxy(jobTrackAddr, conf);
    }

    private ClientProtocol createRPCProxy(InetSocketAddress addr, Configuration conf) throws IOException {
        return (ClientProtocol)RPC.getProxy(ClientProtocol.class, (long)33L, (InetSocketAddress)addr, (UserGroupInformation)this.ugi, (Configuration)conf, (SocketFactory)NetUtils.getSocketFactory((Configuration)conf, ClientProtocol.class));
    }

    private ClientProtocol createClient(Configuration conf) throws IOException {
        ClientProtocol client;
        String tracker = conf.get("mapreduce.jobtracker.address", "local");
        if ("local".equals(tracker)) {
            conf.setInt("mapreduce.job.maps", 1);
            client = new LocalJobRunner(conf);
        } else {
            client = this.createRPCProxy(JobTracker.getAddress(conf), conf);
        }
        return client;
    }

    ClientProtocol getClient() {
        return this.client;
    }

    Configuration getConf() {
        return this.conf;
    }

    public synchronized void close() throws IOException {
        if (!(this.client instanceof LocalJobRunner)) {
            RPC.stopProxy((Object)this.client);
        }
    }

    private Job[] getJobs(JobStatus[] stats) throws IOException {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (JobStatus stat : stats) {
            jobs.add(new Job(this, stat, new JobConf(stat.getJobFile())));
        }
        return jobs.toArray(new Job[0]);
    }

    public synchronized FileSystem getFileSystem() throws IOException, InterruptedException {
        if (this.fs == null) {
            Path sysDir = new Path(this.client.getSystemDir());
            this.fs = sysDir.getFileSystem(this.getConf());
        }
        return this.fs;
    }

    public Job getJob(JobID jobId) throws IOException, InterruptedException {
        JobStatus status = this.client.getJobStatus(jobId);
        if (status != null) {
            return new Job(this, status, new JobConf(status.getJobFile()));
        }
        return null;
    }

    public QueueInfo[] getQueues() throws IOException, InterruptedException {
        return this.client.getQueues();
    }

    public QueueInfo getQueue(String name) throws IOException, InterruptedException {
        return this.client.getQueue(name);
    }

    public ClusterMetrics getClusterStatus() throws IOException, InterruptedException {
        return this.client.getClusterMetrics();
    }

    public TaskTrackerInfo[] getActiveTaskTrackers() throws IOException, InterruptedException {
        return this.client.getActiveTrackers();
    }

    public TaskTrackerInfo[] getBlackListedTaskTrackers() throws IOException, InterruptedException {
        return this.client.getBlacklistedTrackers();
    }

    public Job[] getAllJobs() throws IOException, InterruptedException {
        return this.getJobs(this.client.getAllJobs());
    }

    public Path getSystemDir() throws IOException, InterruptedException {
        if (this.sysDir == null) {
            this.sysDir = new Path(this.client.getSystemDir());
        }
        return this.sysDir;
    }

    public Path getStagingAreaDir() throws IOException, InterruptedException {
        if (this.stagingAreaDir == null) {
            this.stagingAreaDir = new Path(this.client.getStagingAreaDir());
        }
        return this.stagingAreaDir;
    }

    public String getJobHistoryUrl(JobID jobId) throws IOException, InterruptedException {
        if (this.jobHistoryDir == null) {
            this.jobHistoryDir = new Path(this.client.getJobHistoryDir());
        }
        return JobHistory.getJobHistoryFile(this.jobHistoryDir, jobId, this.ugi.getShortUserName()).toString();
    }

    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException, InterruptedException {
        return this.client.getQueueAclsForCurrentUser();
    }

    public QueueInfo[] getRootQueues() throws IOException, InterruptedException {
        return this.client.getRootQueues();
    }

    public QueueInfo[] getChildQueues(String queueName) throws IOException, InterruptedException {
        return this.client.getChildQueues(queueName);
    }

    public State getJobTrackerState() throws IOException, InterruptedException {
        return this.client.getJobTrackerState();
    }

    public long getTaskTrackerExpiryInterval() throws IOException, InterruptedException {
        return this.client.getTaskTrackerExpiryInterval();
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException, InterruptedException {
        Token<DelegationTokenIdentifier> result = this.client.getDelegationToken(renewer);
        InetSocketAddress addr = JobTracker.getAddress(this.conf);
        StringBuilder service = new StringBuilder();
        service.append(NetUtils.normalizeHostName((String)addr.getAddress().getHostAddress()));
        service.append(':');
        service.append(addr.getPort());
        result.setService(new Text(service.toString()));
        return result;
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException, InterruptedException {
        try {
            return this.client.renewDelegationToken(token);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class, AccessControlException.class});
        }
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
        try {
            this.client.cancelDelegationToken(token);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class, AccessControlException.class});
        }
    }

    static {
        ConfigUtil.loadResources();
    }
}

